/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.client.ldap;

import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.util.Assert;

public class KerberosLdapContextSource
extends DefaultSpringSecurityContextSource
implements InitializingBean {
    private Configuration loginConfig;

    public KerberosLdapContextSource(String url) {
        super(url);
    }

    public KerberosLdapContextSource(List<String> urls, String baseDn) {
        super(urls, baseDn);
    }

    public void afterPropertiesSet() {
        try {
            super.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Assert.notNull((Object)this.loginConfig, (String)"loginConfig must be specified");
    }

    protected DirContext getDirContextInstance(final Hashtable environment) throws NamingException {
        environment.put("java.naming.security.authentication", "GSSAPI");
        Subject serviceSubject = this.login();
        final NamingException[] suppressedException = new NamingException[]{null};
        DirContext dirContext = Subject.doAs(serviceSubject, new PrivilegedAction<DirContext>(){

            @Override
            public DirContext run() {
                try {
                    return KerberosLdapContextSource.super.getDirContextInstance(environment);
                }
                catch (NamingException ex) {
                    suppressedException[0] = ex;
                    return null;
                }
            }
        });
        if (suppressedException[0] != null) {
            throw suppressedException[0];
        }
        return dirContext;
    }

    public void setLoginConfig(Configuration loginConfig) {
        this.loginConfig = loginConfig;
    }

    private Subject login() throws AuthenticationException {
        try {
            LoginContext lc = new LoginContext(KerberosLdapContextSource.class.getSimpleName(), null, null, this.loginConfig);
            lc.login();
            return lc.getSubject();
        }
        catch (LoginException ex) {
            AuthenticationException ae = new AuthenticationException(ex.getMessage());
            ae.initCause(ex);
            throw ae;
        }
    }
}

