/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password4j;

import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.Password;
import org.springframework.security.crypto.password.AbstractValidatingPasswordEncoder;
import org.springframework.util.Assert;

abstract class Password4jPasswordEncoder
extends AbstractValidatingPasswordEncoder {
    private final HashingFunction hashingFunction;

    Password4jPasswordEncoder(HashingFunction hashingFunction) {
        Assert.notNull((Object)hashingFunction, (String)"hashingFunction cannot be null");
        this.hashingFunction = hashingFunction;
    }

    @Override
    protected String encodeNonNullPassword(String rawPassword) {
        Hash hash = Password.hash((CharSequence)rawPassword).with(this.hashingFunction);
        return hash.getResult();
    }

    @Override
    protected boolean matchesNonNull(String rawPassword, String encodedPassword) {
        return Password.check((CharSequence)rawPassword, (String)encodedPassword).with(this.hashingFunction);
    }

    @Override
    protected boolean upgradeEncodingNonNull(String encodedPassword) {
        return false;
    }
}

