/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.userdetails;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.UserDetailsAwareConfigurer;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class AbstractDaoAuthenticationConfigurer<B extends ProviderManagerBuilder<B>, C extends AbstractDaoAuthenticationConfigurer<B, C, U>, U extends UserDetailsService>
extends UserDetailsAwareConfigurer<B, U> {
    private DaoAuthenticationProvider provider;
    private final U userDetailsService;

    AbstractDaoAuthenticationConfigurer(U userDetailsService) {
        this.userDetailsService = userDetailsService;
        this.provider = new DaoAuthenticationProvider(userDetailsService);
        if (userDetailsService instanceof UserDetailsPasswordService) {
            this.provider.setUserDetailsPasswordService((UserDetailsPasswordService)userDetailsService);
        }
    }

    public C withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return (C)this;
    }

    public C passwordEncoder(PasswordEncoder passwordEncoder) {
        this.provider.setPasswordEncoder(passwordEncoder);
        return (C)this;
    }

    public C userDetailsPasswordManager(UserDetailsPasswordService passwordManager) {
        this.provider.setUserDetailsPasswordService(passwordManager);
        return (C)this;
    }

    @Override
    public void configure(B builder) {
        this.provider = this.postProcess(this.provider);
        builder.authenticationProvider((AuthenticationProvider)this.provider);
    }

    @Override
    public U getUserDetailsService() {
        return this.userDetailsService;
    }
}

