/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.aot.hint.PrePostAuthorizeHintsRegistrar;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.method.configuration.DeferringMethodInterceptor;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(value="_prePostMethodSecurityConfiguration", proxyBeanMethods=false)
@Role(value=2)
final class PrePostMethodSecurityConfiguration
implements ImportAware,
ApplicationContextAware,
AopInfrastructureBean {
    private static final Pointcut preFilterPointcut = new PreFilterAuthorizationMethodInterceptor().getPointcut();
    private static final Pointcut preAuthorizePointcut = AuthorizationManagerBeforeMethodInterceptor.preAuthorize().getPointcut();
    private static final Pointcut postAuthorizePointcut = AuthorizationManagerAfterMethodInterceptor.postAuthorize().getPointcut();
    private static final Pointcut postFilterPointcut = new PostFilterAuthorizationMethodInterceptor().getPointcut();
    private final PreAuthorizeAuthorizationManager preAuthorizeAuthorizationManager = new PreAuthorizeAuthorizationManager();
    private final PostAuthorizeAuthorizationManager postAuthorizeAuthorizationManager = new PostAuthorizeAuthorizationManager();
    private final PreFilterAuthorizationMethodInterceptor preFilterMethodInterceptor = new PreFilterAuthorizationMethodInterceptor();
    private final AuthorizationManagerBeforeMethodInterceptor preAuthorizeMethodInterceptor;
    private final AuthorizationManagerAfterMethodInterceptor postAuthorizeMethodInterceptor;
    private final PostFilterAuthorizationMethodInterceptor postFilterMethodInterceptor = new PostFilterAuthorizationMethodInterceptor();
    private final DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();

    PrePostMethodSecurityConfiguration(ObjectProvider<ObjectPostProcessor<AuthorizationManager<MethodInvocation>>> preAuthorizeProcessor, ObjectProvider<ObjectPostProcessor<AuthorizationManager<MethodInvocationResult>>> postAuthorizeProcessor) {
        this.preFilterMethodInterceptor.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.preAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.postAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.postFilterMethodInterceptor.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        AuthorizationManager preAuthorize = (AuthorizationManager)((ObjectPostProcessor)preAuthorizeProcessor.getIfUnique(ObjectPostProcessor::identity)).postProcess(this.preAuthorizeAuthorizationManager);
        this.preAuthorizeMethodInterceptor = AuthorizationManagerBeforeMethodInterceptor.preAuthorize((AuthorizationManager)preAuthorize);
        AuthorizationManager postAuthorize = (AuthorizationManager)((ObjectPostProcessor)postAuthorizeProcessor.getIfUnique(ObjectPostProcessor::identity)).postProcess(this.postAuthorizeAuthorizationManager);
        this.postAuthorizeMethodInterceptor = AuthorizationManagerAfterMethodInterceptor.postAuthorize((AuthorizationManager)postAuthorize);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.expressionHandler.setApplicationContext(context);
        this.preAuthorizeAuthorizationManager.setApplicationContext(context);
        this.postAuthorizeAuthorizationManager.setApplicationContext(context);
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
    }

    @Autowired(required=false)
    void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.expressionHandler.setRoleHierarchy(roleHierarchy);
    }

    @Autowired(required=false)
    void setAuthorizationManagerFactory(AuthorizationManagerFactory<MethodInvocation> authorizationManagerFactory) {
        this.expressionHandler.setAuthorizationManagerFactory(authorizationManagerFactory);
    }

    @Autowired(required=false)
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.preFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
        this.preAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
    }

    @Autowired(required=false)
    void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.preFilterMethodInterceptor.setExpressionHandler(expressionHandler);
        this.preAuthorizeAuthorizationManager.setExpressionHandler(expressionHandler);
        this.postAuthorizeAuthorizationManager.setExpressionHandler(expressionHandler);
        this.postFilterMethodInterceptor.setExpressionHandler(expressionHandler);
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.preFilterMethodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
        this.preAuthorizeMethodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
        this.postAuthorizeMethodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
        this.postFilterMethodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
    }

    @Autowired(required=false)
    void setAuthorizationEventPublisher(AuthorizationEventPublisher publisher) {
        this.preAuthorizeMethodInterceptor.setAuthorizationEventPublisher(publisher);
        this.postAuthorizeMethodInterceptor.setAuthorizationEventPublisher(publisher);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preFilterAuthorizationMethodInterceptor(ObjectProvider<PrePostMethodSecurityConfiguration> _prePostMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<PreFilterAuthorizationMethodInterceptor>(preFilterPointcut, () -> ((PrePostMethodSecurityConfiguration)_prePostMethodSecurityConfiguration.getObject()).preFilterMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preAuthorizeAuthorizationMethodInterceptor(ObjectProvider<PrePostMethodSecurityConfiguration> _prePostMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<AuthorizationManagerBeforeMethodInterceptor>(preAuthorizePointcut, () -> ((PrePostMethodSecurityConfiguration)_prePostMethodSecurityConfiguration.getObject()).preAuthorizeMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postAuthorizeAuthorizationMethodInterceptor(ObjectProvider<PrePostMethodSecurityConfiguration> _prePostMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<AuthorizationManagerAfterMethodInterceptor>(postAuthorizePointcut, () -> ((PrePostMethodSecurityConfiguration)_prePostMethodSecurityConfiguration.getObject()).postAuthorizeMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postFilterAuthorizationMethodInterceptor(ObjectProvider<PrePostMethodSecurityConfiguration> _prePostMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<PostFilterAuthorizationMethodInterceptor>(postFilterPointcut, () -> ((PrePostMethodSecurityConfiguration)_prePostMethodSecurityConfiguration.getObject()).postFilterMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static SecurityHintsRegistrar prePostAuthorizeExpressionHintsRegistrar() {
        return new PrePostAuthorizeHintsRegistrar();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.preFilterMethodInterceptor.setOrder(this.preFilterMethodInterceptor.getOrder() + annotation.offset());
        this.preAuthorizeMethodInterceptor.setOrder(this.preAuthorizeMethodInterceptor.getOrder() + annotation.offset());
        this.postAuthorizeMethodInterceptor.setOrder(this.postAuthorizeMethodInterceptor.getOrder() + annotation.offset());
        this.postFilterMethodInterceptor.setOrder(this.postFilterMethodInterceptor.getOrder() + annotation.offset());
    }
}

