/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.ResolvableType;
import org.springframework.security.oauth2.client.AuthorizationCodeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.JwtBearerReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.RefreshTokenReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.TokenExchangeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.JwtBearerGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.reactive.result.method.annotation.OAuth2AuthorizedClientArgumentResolver;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@Import(value={ReactiveOAuth2AuthorizedClientManagerConfiguration.class, OAuth2ClientWebFluxSecurityConfiguration.class})
final class ReactiveOAuth2ClientConfiguration {
    ReactiveOAuth2ClientConfiguration() {
    }

    static final class ReactiveOAuth2AuthorizedClientManagerRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    BeanFactoryAware {
        static final String BEAN_NAME = "authorizedClientManagerRegistrar";
        static final String FACTORY_METHOD_NAME = "getAuthorizedClientManager";
        private static final Set<Class<?>> KNOWN_AUTHORIZED_CLIENT_PROVIDERS = Set.of(AuthorizationCodeReactiveOAuth2AuthorizedClientProvider.class, RefreshTokenReactiveOAuth2AuthorizedClientProvider.class, ClientCredentialsReactiveOAuth2AuthorizedClientProvider.class, JwtBearerReactiveOAuth2AuthorizedClientProvider.class, TokenExchangeReactiveOAuth2AuthorizedClientProvider.class);
        private final AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
        private ListableBeanFactory beanFactory;

        ReactiveOAuth2AuthorizedClientManagerRegistrar() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (this.getBeanNamesForType(ReactiveOAuth2AuthorizedClientManager.class).length != 0 || this.getBeanNamesForType(ReactiveClientRegistrationRepository.class).length != 1 || this.getBeanNamesForType(ServerOAuth2AuthorizedClientRepository.class).length != 1 && this.getBeanNamesForType(ReactiveOAuth2AuthorizedClientService.class).length != 1) {
                return;
            }
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ReactiveOAuth2AuthorizedClientManager.class).setFactoryMethodOnBean(FACTORY_METHOD_NAME, BEAN_NAME).getBeanDefinition();
            registry.registerBeanDefinition(this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry), (BeanDefinition)beanDefinition);
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }

        ReactiveOAuth2AuthorizedClientManager getAuthorizedClientManagerIfAvailable() {
            if (this.getBeanNamesForType(ReactiveClientRegistrationRepository.class).length != 1 || this.getBeanNamesForType(ServerOAuth2AuthorizedClientRepository.class).length != 1 && this.getBeanNamesForType(ReactiveOAuth2AuthorizedClientService.class).length != 1) {
                return null;
            }
            return this.getAuthorizedClientManager();
        }

        ReactiveOAuth2AuthorizedClientManager getAuthorizedClientManager() {
            ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider;
            ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
            ReactiveClientRegistrationRepository clientRegistrationRepository = (ReactiveClientRegistrationRepository)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ReactiveClientRegistrationRepository.class, (boolean)true, (boolean)true);
            try {
                authorizedClientRepository = (ServerOAuth2AuthorizedClientRepository)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerOAuth2AuthorizedClientRepository.class, (boolean)true, (boolean)true);
            }
            catch (NoSuchBeanDefinitionException ex) {
                ReactiveOAuth2AuthorizedClientService authorizedClientService = (ReactiveOAuth2AuthorizedClientService)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ReactiveOAuth2AuthorizedClientService.class, (boolean)true, (boolean)true);
                authorizedClientRepository = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            }
            Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviderBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ReactiveOAuth2AuthorizedClientProvider.class, (boolean)true, (boolean)true).values();
            if (this.hasDelegatingAuthorizedClientProvider(authorizedClientProviderBeans)) {
                authorizedClientProvider = authorizedClientProviderBeans.iterator().next();
            } else {
                ReactiveOAuth2AuthorizedClientProvider tokenExchangeAuthorizedClientProvider;
                ArrayList<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders = new ArrayList<ReactiveOAuth2AuthorizedClientProvider>();
                authorizedClientProviders.add(this.getAuthorizationCodeAuthorizedClientProvider(authorizedClientProviderBeans));
                authorizedClientProviders.add(this.getRefreshTokenAuthorizedClientProvider(authorizedClientProviderBeans));
                authorizedClientProviders.add(this.getClientCredentialsAuthorizedClientProvider(authorizedClientProviderBeans));
                ReactiveOAuth2AuthorizedClientProvider jwtBearerAuthorizedClientProvider = this.getJwtBearerAuthorizedClientProvider(authorizedClientProviderBeans);
                if (jwtBearerAuthorizedClientProvider != null) {
                    authorizedClientProviders.add(jwtBearerAuthorizedClientProvider);
                }
                if ((tokenExchangeAuthorizedClientProvider = this.getTokenExchangeAuthorizedClientProvider(authorizedClientProviderBeans)) != null) {
                    authorizedClientProviders.add(tokenExchangeAuthorizedClientProvider);
                }
                authorizedClientProviders.addAll(this.getAdditionalAuthorizedClientProviders(authorizedClientProviderBeans));
                authorizedClientProvider = new DelegatingReactiveOAuth2AuthorizedClientProvider(authorizedClientProviders);
            }
            DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            Consumer authorizedClientManagerConsumer = (Consumer)this.getBeanOfType(ResolvableType.forClassWithGenerics(Consumer.class, (Class[])new Class[]{DefaultReactiveOAuth2AuthorizedClientManager.class}));
            if (authorizedClientManagerConsumer != null) {
                authorizedClientManagerConsumer.accept(authorizedClientManager);
            }
            return authorizedClientManager;
        }

        private boolean hasDelegatingAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            if (authorizedClientProviders.size() != 1) {
                return false;
            }
            return authorizedClientProviders.iterator().next() instanceof DelegatingReactiveOAuth2AuthorizedClientProvider;
        }

        private ReactiveOAuth2AuthorizedClientProvider getAuthorizationCodeAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            AuthorizationCodeReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, AuthorizationCodeReactiveOAuth2AuthorizedClientProvider.class);
            if (authorizedClientProvider == null) {
                authorizedClientProvider = new AuthorizationCodeReactiveOAuth2AuthorizedClientProvider();
            }
            return authorizedClientProvider;
        }

        private ReactiveOAuth2AuthorizedClientProvider getRefreshTokenAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            ReactiveOAuth2AccessTokenResponseClient accessTokenResponseClient;
            RefreshTokenReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, RefreshTokenReactiveOAuth2AuthorizedClientProvider.class);
            if (authorizedClientProvider == null) {
                authorizedClientProvider = new RefreshTokenReactiveOAuth2AuthorizedClientProvider();
            }
            if ((accessTokenResponseClient = (ReactiveOAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2RefreshTokenGrantRequest.class}))) != null) {
                authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
            }
            return authorizedClientProvider;
        }

        private ReactiveOAuth2AuthorizedClientProvider getClientCredentialsAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            ReactiveOAuth2AccessTokenResponseClient accessTokenResponseClient;
            ClientCredentialsReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, ClientCredentialsReactiveOAuth2AuthorizedClientProvider.class);
            if (authorizedClientProvider == null) {
                authorizedClientProvider = new ClientCredentialsReactiveOAuth2AuthorizedClientProvider();
            }
            if ((accessTokenResponseClient = (ReactiveOAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2ClientCredentialsGrantRequest.class}))) != null) {
                authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
            }
            return authorizedClientProvider;
        }

        private ReactiveOAuth2AuthorizedClientProvider getJwtBearerAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            JwtBearerReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, JwtBearerReactiveOAuth2AuthorizedClientProvider.class);
            ReactiveOAuth2AccessTokenResponseClient accessTokenResponseClient = (ReactiveOAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{JwtBearerGrantRequest.class}));
            if (accessTokenResponseClient != null) {
                if (authorizedClientProvider == null) {
                    authorizedClientProvider = new JwtBearerReactiveOAuth2AuthorizedClientProvider();
                }
                authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
            }
            return authorizedClientProvider;
        }

        private ReactiveOAuth2AuthorizedClientProvider getTokenExchangeAuthorizedClientProvider(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            TokenExchangeReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, TokenExchangeReactiveOAuth2AuthorizedClientProvider.class);
            ReactiveOAuth2AccessTokenResponseClient accessTokenResponseClient = (ReactiveOAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{TokenExchangeGrantRequest.class}));
            if (accessTokenResponseClient != null) {
                if (authorizedClientProvider == null) {
                    authorizedClientProvider = new TokenExchangeReactiveOAuth2AuthorizedClientProvider();
                }
                authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
            }
            return authorizedClientProvider;
        }

        private List<ReactiveOAuth2AuthorizedClientProvider> getAdditionalAuthorizedClientProviders(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
            ArrayList<ReactiveOAuth2AuthorizedClientProvider> additionalAuthorizedClientProviders = new ArrayList<ReactiveOAuth2AuthorizedClientProvider>(authorizedClientProviders);
            additionalAuthorizedClientProviders.removeIf(provider -> KNOWN_AUTHORIZED_CLIENT_PROVIDERS.contains(provider.getClass()));
            return additionalAuthorizedClientProviders;
        }

        private <T extends ReactiveOAuth2AuthorizedClientProvider> T getAuthorizedClientProviderByType(Collection<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders, Class<T> providerClass) {
            ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = null;
            for (ReactiveOAuth2AuthorizedClientProvider current : authorizedClientProviders) {
                if (!providerClass.isInstance(current)) continue;
                ReactiveOAuth2AuthorizedClientManagerRegistrar.assertAuthorizedClientProviderIsNull(authorizedClientProvider);
                authorizedClientProvider = (ReactiveOAuth2AuthorizedClientProvider)providerClass.cast(current);
            }
            return (T)authorizedClientProvider;
        }

        private static void assertAuthorizedClientProviderIsNull(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
            if (authorizedClientProvider != null) {
                throw new BeanInitializationException(String.format("Unable to create a %s bean. Expected one bean of type %s, but found multiple. Please consider defining only a single bean of this type, or define a %s bean yourself.", ReactiveOAuth2AuthorizedClientManager.class.getName(), authorizedClientProvider.getClass().getName(), ReactiveOAuth2AuthorizedClientManager.class.getName()));
            }
        }

        private <T> String[] getBeanNamesForType(Class<T> beanClass) {
            return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, beanClass, (boolean)true, (boolean)true);
        }

        private <T> T getBeanOfType(ResolvableType resolvableType) {
            ObjectProvider objectProvider = this.beanFactory.getBeanProvider(resolvableType, true);
            return (T)objectProvider.getIfAvailable();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class OAuth2ClientWebFluxSecurityConfiguration
    implements WebFluxConfigurer {
        private final ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
        private final ReactiveOAuth2AuthorizedClientManagerRegistrar authorizedClientManagerRegistrar;

        OAuth2ClientWebFluxSecurityConfiguration(ObjectProvider<ReactiveOAuth2AuthorizedClientManager> authorizedClientManager, ReactiveOAuth2AuthorizedClientManagerRegistrar authorizedClientManagerRegistrar) {
            this.authorizedClientManager = (ReactiveOAuth2AuthorizedClientManager)authorizedClientManager.getIfUnique();
            this.authorizedClientManagerRegistrar = authorizedClientManagerRegistrar;
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            ReactiveOAuth2AuthorizedClientManager authorizedClientManager = this.getAuthorizedClientManager();
            if (authorizedClientManager != null) {
                configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{new OAuth2AuthorizedClientArgumentResolver(authorizedClientManager)});
            }
        }

        private ReactiveOAuth2AuthorizedClientManager getAuthorizedClientManager() {
            if (this.authorizedClientManager != null) {
                return this.authorizedClientManager;
            }
            return this.authorizedClientManagerRegistrar.getAuthorizedClientManagerIfAvailable();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ReactiveOAuth2AuthorizedClientManagerConfiguration {
        ReactiveOAuth2AuthorizedClientManagerConfiguration() {
        }

        @Bean(name={"authorizedClientManagerRegistrar"})
        ReactiveOAuth2AuthorizedClientManagerRegistrar authorizedClientManagerRegistrar() {
            return new ReactiveOAuth2AuthorizedClientManagerRegistrar();
        }
    }
}

