/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientRegistrationAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2ClientRegistrationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2ClientRegistrationAuthenticationConverter;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2ClientRegistrationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> clientRegistrationRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> clientRegistrationRequestConvertersConsumer = clientRegistrationRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler clientRegistrationResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;
    private boolean openRegistrationAllowed;

    OAuth2ClientRegistrationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2ClientRegistrationEndpointConfigurer clientRegistrationRequestConverter(AuthenticationConverter clientRegistrationRequestConverter) {
        Assert.notNull((Object)clientRegistrationRequestConverter, (String)"clientRegistrationRequestConverter cannot be null");
        this.clientRegistrationRequestConverters.add(clientRegistrationRequestConverter);
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer clientRegistrationRequestConverters(Consumer<List<AuthenticationConverter>> clientRegistrationRequestConvertersConsumer) {
        Assert.notNull(clientRegistrationRequestConvertersConsumer, (String)"clientRegistrationRequestConvertersConsumer cannot be null");
        this.clientRegistrationRequestConvertersConsumer = clientRegistrationRequestConvertersConsumer;
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer clientRegistrationResponseHandler(AuthenticationSuccessHandler clientRegistrationResponseHandler) {
        this.clientRegistrationResponseHandler = clientRegistrationResponseHandler;
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public OAuth2ClientRegistrationEndpointConfigurer openRegistrationAllowed(boolean openRegistrationAllowed) {
        this.openRegistrationAllowed = openRegistrationAllowed;
        return this;
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String clientRegistrationEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getClientRegistrationEndpoint()) : authorizationServerSettings.getClientRegistrationEndpoint();
        this.requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, clientRegistrationEndpointUri);
        List<AuthenticationProvider> authenticationProviders = OAuth2ClientRegistrationEndpointConfigurer.createDefaultAuthenticationProviders(httpSecurity, this.openRegistrationAllowed);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> httpSecurity.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        AuthenticationManager authenticationManager = httpSecurity.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String clientRegistrationEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getClientRegistrationEndpoint()) : authorizationServerSettings.getClientRegistrationEndpoint();
        OAuth2ClientRegistrationEndpointFilter clientRegistrationEndpointFilter = new OAuth2ClientRegistrationEndpointFilter(authenticationManager, clientRegistrationEndpointUri);
        List<AuthenticationConverter> authenticationConverters = OAuth2ClientRegistrationEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.clientRegistrationRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.clientRegistrationRequestConverters);
        }
        this.clientRegistrationRequestConvertersConsumer.accept(authenticationConverters);
        clientRegistrationEndpointFilter.setAuthenticationConverter((AuthenticationConverter)new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.clientRegistrationResponseHandler != null) {
            clientRegistrationEndpointFilter.setAuthenticationSuccessHandler(this.clientRegistrationResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            clientRegistrationEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        httpSecurity.addFilterAfter((Filter)this.postProcess(clientRegistrationEndpointFilter), AuthorizationFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add((AuthenticationConverter)new OAuth2ClientRegistrationAuthenticationConverter());
        return authenticationConverters;
    }

    private static List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity httpSecurity, boolean openRegistrationAllowed) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OAuth2ClientRegistrationAuthenticationProvider clientRegistrationAuthenticationProvider = new OAuth2ClientRegistrationAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationService(httpSecurity));
        PasswordEncoder passwordEncoder = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, PasswordEncoder.class);
        if (passwordEncoder != null) {
            clientRegistrationAuthenticationProvider.setPasswordEncoder(passwordEncoder);
        }
        clientRegistrationAuthenticationProvider.setOpenRegistrationAllowed(openRegistrationAllowed);
        authenticationProviders.add((AuthenticationProvider)clientRegistrationAuthenticationProvider);
        return authenticationProviders;
    }
}

