/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import jakarta.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final RequestMatcher ANY_REQUEST = AnyRequestMatcher.INSTANCE;
    private ApplicationContext context;
    private boolean anyRequestConfigured = false;
    private final Log logger = LogFactory.getLog(this.getClass());

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure anyRequest after itself");
        C configurer = this.requestMatchers(ANY_REQUEST);
        this.anyRequestConfigured = true;
        return configurer;
    }

    public C dispatcherTypeMatchers(@Nullable HttpMethod method, DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (DispatcherType dispatcherType : dispatcherTypes) {
            matchers.add((RequestMatcher)new DispatcherTypeRequestMatcher(dispatcherType, method));
        }
        return this.chainRequestMatchers(matchers);
    }

    public C dispatcherTypeMatchers(DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        return this.dispatcherTypeMatchers((HttpMethod)null, dispatcherTypes);
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    public C requestMatchers(HttpMethod method, String ... patterns) {
        if (this.anyPathsDontStartWithLeadingSlash(patterns)) {
            this.logger.warn((Object)("One of the patterns in " + Arrays.toString(patterns) + " is missing a leading slash. This is discouraged; please include the leading slash in all your request matcher patterns. In future versions of Spring Security, leaving out the leading slash will result in an exception."));
        }
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        PathPatternRequestMatcher.Builder builder = (PathPatternRequestMatcher.Builder)this.context.getBean(PathPatternRequestMatcher.Builder.class);
        ArrayList<PathPatternRequestMatcher> matchers = new ArrayList<PathPatternRequestMatcher>();
        for (String pattern : patterns) {
            matchers.add(builder.matcher(method, pattern));
        }
        return this.requestMatchers(matchers.toArray(new RequestMatcher[0]));
    }

    private boolean anyPathsDontStartWithLeadingSlash(String ... patterns) {
        for (String pattern : patterns) {
            if (pattern.startsWith("/")) continue;
            return true;
        }
        return false;
    }

    public C requestMatchers(String ... patterns) {
        return this.requestMatchers((HttpMethod)null, patterns);
    }

    public C requestMatchers(HttpMethod method) {
        return this.requestMatchers(method, "/**");
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);
}

