/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.util.Assert;

public class UserDetailsMapFactoryBean
implements FactoryBean<Collection<UserDetails>> {
    private final Map<String, String> userProperties;

    public UserDetailsMapFactoryBean(Map<String, String> userProperties) {
        Assert.notNull(userProperties, (String)"userProperties cannot be null");
        this.userProperties = userProperties;
    }

    public Collection<UserDetails> getObject() throws Exception {
        ArrayList<UserDetails> users = new ArrayList<UserDetails>(this.userProperties.size());
        UserAttributeEditor editor = new UserAttributeEditor();
        for (Map.Entry<String, String> entry : this.userProperties.entrySet()) {
            String name = entry.getKey();
            String property = entry.getValue();
            editor.setAsText(property);
            UserAttribute attr = (UserAttribute)editor.getValue();
            if (attr == null) {
                throw new IllegalStateException("The entry with username '" + name + "' and value '" + property + "' could not be converted to a UserDetails.");
            }
            UserDetails user = User.withUsername((String)name).password(attr.getPassword()).disabled(!attr.isEnabled()).authorities((Collection)attr.getAuthorities()).build();
            users.add(user);
        }
        return users;
    }

    public Class<?> getObjectType() {
        return Collection.class;
    }
}

