/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;

public final class PortMapperConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<PortMapperConfigurer<H>, H> {
    private PortMapper portMapper;
    private Map<String, String> httpsPortMappings = new HashMap<String, String>();

    public PortMapperConfigurer<H> portMapper(PortMapper portMapper) {
        this.portMapper = portMapper;
        return this;
    }

    public HttpPortMapping http(int httpPort) {
        return new HttpPortMapping(httpPort);
    }

    @Override
    public void init(H http) throws Exception {
        http.setSharedObject(PortMapper.class, (PortMapper)this.getPortMapper());
    }

    private PortMapper getPortMapper() {
        if (this.portMapper == null) {
            PortMapperImpl portMapper = new PortMapperImpl();
            portMapper.setPortMappings(this.httpsPortMappings);
            this.portMapper = portMapper;
        }
        return this.portMapper;
    }

    public final class HttpPortMapping {
        private final int httpPort;

        private HttpPortMapping(int httpPort) {
            this.httpPort = httpPort;
        }

        public PortMapperConfigurer<H> mapsTo(int httpsPort) {
            PortMapperConfigurer.this.httpsPortMappings.put(String.valueOf(this.httpPort), String.valueOf(httpsPort));
            return PortMapperConfigurer.this;
        }
    }
}

