/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.authentication.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.security.config.authentication.JdbcUserServiceBeanDefinitionParser;
import org.springframework.security.config.authentication.PasswordEncoderParser;
import org.springframework.security.config.authentication.UserServiceBeanDefinitionParser;
import org.springframework.security.config.ldap.LdapUserServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AuthenticationProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private static String ATT_USER_DETAILS_REF = "user-service-ref";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition authProvider = new RootBeanDefinition(DaoAuthenticationProvider.class);
        authProvider.setSource(parserContext.extractSource((Object)element));
        Element passwordEncoderElt = DomUtils.getChildElementByTagName((Element)element, (String)"password-encoder");
        if (passwordEncoderElt != null) {
            PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElt, parserContext);
            authProvider.getPropertyValues().addPropertyValue("passwordEncoder", (Object)pep.getPasswordEncoder());
            if (pep.getSaltSource() != null) {
                authProvider.getPropertyValues().addPropertyValue("saltSource", (Object)pep.getSaltSource());
            }
        }
        Element userServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"user-service");
        Element jdbcUserServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"jdbc-user-service");
        Element ldapUserServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"ldap-user-service");
        String ref = element.getAttribute(ATT_USER_DETAILS_REF);
        if (StringUtils.hasText((String)ref)) {
            if (userServiceElt != null || jdbcUserServiceElt != null || ldapUserServiceElt != null) {
                parserContext.getReaderContext().error("The " + ATT_USER_DETAILS_REF + " attribute cannot be used in combination with child" + "elements '" + "user-service" + "', '" + "jdbc-user-service" + "' or '" + "ldap-user-service" + "'", (Object)element);
            }
        } else {
            AbstractUserDetailsServiceBeanDefinitionParser parser = null;
            Element elt = null;
            if (userServiceElt != null) {
                elt = userServiceElt;
                parser = new UserServiceBeanDefinitionParser();
            } else if (jdbcUserServiceElt != null) {
                elt = jdbcUserServiceElt;
                parser = new JdbcUserServiceBeanDefinitionParser();
            } else if (ldapUserServiceElt != null) {
                elt = ldapUserServiceElt;
                parser = new LdapUserServiceBeanDefinitionParser();
            } else {
                parserContext.getReaderContext().error("A user-service is required", (Object)element);
            }
            parser.parse(elt, parserContext);
            ref = parser.getId();
            String cacheRef = elt.getAttribute("cache-ref");
            if (StringUtils.hasText((String)cacheRef)) {
                authProvider.getPropertyValues().addPropertyValue("userCache", (Object)new RuntimeBeanReference(cacheRef));
            }
        }
        authProvider.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(ref));
        return authProvider;
    }
}

