/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method.aspectj;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.util.Assert;

class JoinPointMethodInvocation
implements MethodInvocation {
    private final JoinPoint jp;
    private final Method method;
    private final Object target;
    private final Supplier<Object> proceed;

    public JoinPointMethodInvocation(JoinPoint jp, Supplier<Object> proceed) {
        this.jp = jp;
        this.target = jp.getTarget() != null ? jp.getTarget() : jp.getSignature().getDeclaringType();
        String targetMethodName = jp.getStaticPart().getSignature().getName();
        Class[] types = ((CodeSignature)jp.getStaticPart().getSignature()).getParameterTypes();
        Class declaringType = jp.getStaticPart().getSignature().getDeclaringType();
        this.method = this.findMethod(targetMethodName, declaringType, types);
        Assert.notNull((Object)this.method, () -> "Could not obtain target method from JoinPoint: '" + jp + "'");
        this.proceed = proceed;
    }

    private Method findMethod(String name, Class<?> declaringType, Class<?>[] params) {
        Method method = null;
        try {
            method = declaringType.getMethod(name, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method == null) {
            try {
                method = declaringType.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.jp.getArgs();
    }

    public AccessibleObject getStaticPart() {
        return this.method;
    }

    public Object getThis() {
        return this.target;
    }

    public Object proceed() throws Throwable {
        return this.proceed.get();
    }
}

