/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public class AclAuthorizationStrategyImpl
implements AclAuthorizationStrategy {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final GrantedAuthority gaGeneralChanges;
    private final GrantedAuthority gaModifyAuditing;
    private final GrantedAuthority gaTakeOwnership;
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public AclAuthorizationStrategyImpl(GrantedAuthority ... auths) {
        Assert.isTrue((auths != null && (auths.length == 3 || auths.length == 1) ? 1 : 0) != 0, (String)"One or three GrantedAuthority instances required");
        if (auths.length == 3) {
            this.gaTakeOwnership = auths[0];
            this.gaModifyAuditing = auths[1];
            this.gaGeneralChanges = auths[2];
        } else {
            this.gaTakeOwnership = auths[0];
            this.gaModifyAuditing = auths[0];
            this.gaGeneralChanges = auths[0];
        }
    }

    @Override
    public void securityCheck(Acl acl, int changeType) {
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        if (context == null || context.getAuthentication() == null || !context.getAuthentication().isAuthenticated()) {
            throw new AccessDeniedException("Authenticated principal required to operate with ACLs");
        }
        Authentication authentication = context.getAuthentication();
        Sid currentUser = this.createCurrentUser(authentication);
        if (currentUser.equals(acl.getOwner()) && (changeType == 2 || changeType == 0)) {
            return;
        }
        Set authorities = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        if (acl.getOwner() instanceof GrantedAuthoritySid && authorities.contains(((GrantedAuthoritySid)acl.getOwner()).getGrantedAuthority())) {
            return;
        }
        GrantedAuthority requiredAuthority = this.getRequiredAuthority(changeType);
        if (authorities.contains(requiredAuthority.getAuthority())) {
            return;
        }
        List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
        if (acl.isGranted(Arrays.asList(BasePermission.ADMINISTRATION), sids, false)) {
            return;
        }
        throw new AccessDeniedException("Principal does not have required ACL permissions to perform requested operation");
    }

    private GrantedAuthority getRequiredAuthority(int changeType) {
        if (changeType == 1) {
            return this.gaModifyAuditing;
        }
        if (changeType == 2) {
            return this.gaGeneralChanges;
        }
        if (changeType == 0) {
            return this.gaTakeOwnership;
        }
        throw new IllegalArgumentException("Unknown change type");
    }

    protected Sid createCurrentUser(Authentication authentication) {
        return new PrincipalSid(authentication);
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

