/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultRequestEnhancer;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.auth.ClientAuthenticationHandler;
import org.springframework.security.oauth2.client.token.auth.DefaultClientAuthenticationHandler;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.http.converter.FormOAuth2AccessTokenMessageConverter;
import org.springframework.security.oauth2.http.converter.FormOAuth2ExceptionHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public abstract class OAuth2AccessTokenSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final FormHttpMessageConverter FORM_MESSAGE_CONVERTER = new FormHttpMessageConverter();
    private RestOperations restTemplate;
    private List<HttpMessageConverter<?>> messageConverters;
    private ClientAuthenticationHandler authenticationHandler = new DefaultClientAuthenticationHandler();
    private ResponseErrorHandler responseErrorHandler = new AccessTokenErrorHandler();
    private List<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();
    private RequestEnhancer tokenRequestEnhancer = new DefaultRequestEnhancer();
    private ClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory(){

        protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
            super.prepareConnection(connection, httpMethod);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
        }
    };

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setTokenRequestEnhancer(RequestEnhancer tokenRequestEnhancer) {
        this.tokenRequestEnhancer = tokenRequestEnhancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RestOperations getRestTemplate() {
        if (this.restTemplate == null) {
            OAuth2AccessTokenSupport oAuth2AccessTokenSupport = this;
            synchronized (oAuth2AccessTokenSupport) {
                if (this.restTemplate == null) {
                    RestTemplate restTemplate = new RestTemplate();
                    restTemplate.setErrorHandler(this.getResponseErrorHandler());
                    restTemplate.setRequestFactory(this.requestFactory);
                    restTemplate.setInterceptors(this.interceptors);
                    this.restTemplate = restTemplate;
                }
            }
        }
        if (this.messageConverters == null) {
            this.setMessageConverters(new RestTemplate().getMessageConverters());
        }
        return this.restTemplate;
    }

    public void setAuthenticationHandler(ClientAuthenticationHandler authenticationHandler) {
        this.authenticationHandler = authenticationHandler;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = new ArrayList(messageConverters);
        this.messageConverters.add((HttpMessageConverter<?>)new FormOAuth2AccessTokenMessageConverter());
        this.messageConverters.add(new FormOAuth2ExceptionHttpMessageConverter());
    }

    protected OAuth2AccessToken retrieveToken(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) throws OAuth2AccessDeniedException {
        try {
            this.authenticationHandler.authenticateTokenRequest(resource, form, headers);
            this.tokenRequestEnhancer.enhance(request, resource, form, headers);
            final AccessTokenRequest copy = request;
            final ResponseExtractor<OAuth2AccessToken> delegate = this.getResponseExtractor();
            ResponseExtractor<OAuth2AccessToken> extractor = new ResponseExtractor<OAuth2AccessToken>(){

                public OAuth2AccessToken extractData(ClientHttpResponse response) throws IOException {
                    if (response.getHeaders().containsKey((Object)"Set-Cookie")) {
                        copy.setCookie(response.getHeaders().getFirst("Set-Cookie"));
                    }
                    return (OAuth2AccessToken)delegate.extractData(response);
                }
            };
            return (OAuth2AccessToken)this.getRestTemplate().execute(this.getAccessTokenUri(resource, form), this.getHttpMethod(), this.getRequestCallback(resource, form, headers), (ResponseExtractor)extractor, form.toSingleValueMap());
        }
        catch (OAuth2Exception oe) {
            throw new OAuth2AccessDeniedException("Access token denied.", resource, oe);
        }
        catch (RestClientException rce) {
            throw new OAuth2AccessDeniedException("Error requesting access token.", resource, rce);
        }
    }

    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    protected String getAccessTokenUri(OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form) {
        String accessTokenUri = resource.getAccessTokenUri();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving token from " + accessTokenUri));
        }
        StringBuilder builder = new StringBuilder(accessTokenUri);
        if (this.getHttpMethod() == HttpMethod.GET) {
            String separator = "?";
            if (accessTokenUri.contains("?")) {
                separator = "&";
            }
            for (String key : form.keySet()) {
                builder.append(separator);
                builder.append(key + "={" + key + "}");
                separator = "&";
            }
        }
        return builder.toString();
    }

    protected ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"'requestFactory' must not be null");
        this.requestFactory = requestFactory;
    }

    protected ResponseExtractor<OAuth2AccessToken> getResponseExtractor() {
        this.getRestTemplate();
        return new HttpMessageConverterExtractor(OAuth2AccessToken.class, this.messageConverters);
    }

    protected RequestCallback getRequestCallback(OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
        return new OAuth2AuthTokenCallback(form, headers);
    }

    private class AccessTokenErrorHandler
    extends DefaultResponseErrorHandler {
        private AccessTokenErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            for (HttpMessageConverter converter : OAuth2AccessTokenSupport.this.messageConverters) {
                OAuth2Exception ex;
                if (!converter.canRead(OAuth2Exception.class, response.getHeaders().getContentType())) continue;
                try {
                    ex = (OAuth2Exception)converter.read(OAuth2Exception.class, (HttpInputMessage)response);
                }
                catch (Exception e) {
                    continue;
                }
                throw ex;
            }
            super.handleError(response);
        }
    }

    private class OAuth2AuthTokenCallback
    implements RequestCallback {
        private final MultiValueMap<String, String> form;
        private final HttpHeaders headers;

        private OAuth2AuthTokenCallback(MultiValueMap<String, String> form, HttpHeaders headers) {
            this.form = form;
            this.headers = headers;
        }

        public void doWithRequest(ClientHttpRequest request) throws IOException {
            request.getHeaders().putAll((Map)this.headers);
            request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED));
            FORM_MESSAGE_CONVERTER.write(this.form, MediaType.APPLICATION_FORM_URLENCODED, (HttpOutputMessage)request);
        }
    }
}

