/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth.common.OAuthException;
import org.springframework.security.oauth.provider.ConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetailsService;
import org.springframework.security.oauth.provider.InvalidOAuthParametersException;

public class InMemoryConsumerDetailsService
implements ConsumerDetailsService {
    private Map<String, ? extends ConsumerDetails> consumerDetailsStore = new HashMap<String, ConsumerDetails>();

    @Override
    public ConsumerDetails loadConsumerByConsumerKey(String consumerKey) throws OAuthException {
        ConsumerDetails details = this.consumerDetailsStore.get(consumerKey);
        if (details == null) {
            throw new InvalidOAuthParametersException("Consumer not found: " + consumerKey);
        }
        return details;
    }

    public Map<String, ? extends ConsumerDetails> getConsumerDetailsStore() {
        return this.consumerDetailsStore;
    }

    public void setConsumerDetailsStore(Map<String, ? extends ConsumerDetails> consumerDetailsStore) {
        this.consumerDetailsStore = consumerDetailsStore;
    }
}

