/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.restdocs.operation.ResponseCookie;
import org.springframework.util.StringUtils;

class MockMvcResponseConverter
implements ResponseConverter<MockHttpServletResponse> {
    MockMvcResponseConverter() {
    }

    public OperationResponse convert(MockHttpServletResponse mockResponse) {
        HttpHeaders headers = this.extractHeaders(mockResponse);
        Collection<ResponseCookie> cookies = this.extractCookies(mockResponse);
        return new OperationResponseFactory().create(HttpStatusCode.valueOf((int)mockResponse.getStatus()), headers, mockResponse.getContentAsByteArray(), cookies);
    }

    private Collection<ResponseCookie> extractCookies(MockHttpServletResponse mockResponse) {
        if (mockResponse.getCookies() == null || mockResponse.getCookies().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ResponseCookie> cookies = new ArrayList<ResponseCookie>();
        for (Cookie cookie : mockResponse.getCookies()) {
            cookies.add(new ResponseCookie(cookie.getName(), cookie.getValue()));
        }
        return cookies;
    }

    private HttpHeaders extractHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : response.getHeaderNames()) {
            for (String value : response.getHeaders(headerName)) {
                headers.add(headerName, value);
            }
        }
        if (response.getCookies() != null && !headers.containsHeader("Set-Cookie")) {
            for (Cookie cookie : response.getCookies()) {
                headers.add("Set-Cookie", this.generateSetCookieHeader(cookie));
            }
        }
        return headers;
    }

    private String generateSetCookieHeader(Cookie cookie) {
        StringBuilder header = new StringBuilder();
        header.append(cookie.getName());
        header.append('=');
        this.appendIfAvailable(header, cookie.getValue());
        int maxAge = cookie.getMaxAge();
        if (maxAge > -1) {
            header.append(";Max-Age=");
            header.append(maxAge);
        }
        this.appendIfAvailable(header, "; Domain=", cookie.getDomain());
        this.appendIfAvailable(header, "; Path=", cookie.getPath());
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        return header.toString();
    }

    private void appendIfAvailable(StringBuilder header, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append("");
            header.append(value);
        }
    }

    private void appendIfAvailable(StringBuilder header, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append(name);
            header.append(value);
        }
    }
}

