/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.util.Map;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.config.AbstractNestedConfigurer;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class UriConfigurer
extends AbstractNestedConfigurer<MockMvcRestDocumentationConfigurer>
implements MockMvcConfigurer {
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    private String scheme = "http";
    private String host = "localhost";
    private int port = 8080;

    UriConfigurer(MockMvcRestDocumentationConfigurer parent) {
        super((Object)parent);
    }

    public UriConfigurer withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UriConfigurer withHost(String host) {
        this.host = host;
        return this;
    }

    public UriConfigurer withPort(int port) {
        this.port = port;
        return this;
    }

    public void apply(Map<String, Object> configuration, RestDocumentationContext context) {
        MockHttpServletRequest request = (MockHttpServletRequest)configuration.get(MockHttpServletRequest.class.getName());
        request.setScheme(this.scheme);
        request.setServerPort(this.port);
        request.setServerName(this.host);
    }

    public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
        ((MockMvcRestDocumentationConfigurer)((Object)this.and())).afterConfigurerAdded(builder);
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return ((MockMvcRestDocumentationConfigurer)((Object)this.and())).beforeMockMvcCreated(builder, context);
    }
}

