/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import javax.servlet.http.Cookie;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.util.StringUtils;

class MockMvcResponseConverter
implements ResponseConverter<MockHttpServletResponse> {
    MockMvcResponseConverter() {
    }

    public OperationResponse convert(MockHttpServletResponse mockResponse) {
        return new OperationResponseFactory().create(mockResponse.getStatus(), this.extractHeaders(mockResponse), mockResponse.getContentAsByteArray());
    }

    private HttpHeaders extractHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : response.getHeaderNames()) {
            for (String value : response.getHeaders(headerName)) {
                headers.add(headerName, value);
            }
        }
        if (response.getCookies() != null && !headers.containsKey((Object)"Set-Cookie")) {
            for (Cookie cookie : response.getCookies()) {
                headers.add("Set-Cookie", this.generateSetCookieHeader(cookie));
            }
        }
        return headers;
    }

    private String generateSetCookieHeader(Cookie cookie) {
        StringBuilder header = new StringBuilder();
        header.append(cookie.getName());
        header.append('=');
        this.appendIfAvailable(header, cookie.getValue());
        int maxAge = cookie.getMaxAge();
        if (maxAge > -1) {
            header.append(";Max-Age=");
            header.append(maxAge);
        }
        this.appendIfAvailable(header, "; Domain=", cookie.getDomain());
        this.appendIfAvailable(header, "; Path=", cookie.getPath());
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        return header.toString();
    }

    private void appendIfAvailable(StringBuilder header, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append("");
            header.append(value);
        }
    }

    private void appendIfAvailable(StringBuilder header, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append(name);
            header.append(value);
        }
    }
}

