/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener.adapter;

import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.listener.adapter.DelegatingInvocableHandler;
import org.springframework.util.Assert;

public class HandlerAdapter {
    private final @Nullable InvocableHandlerMethod invokerHandlerMethod;
    private final @Nullable DelegatingInvocableHandler delegatingHandler;

    public HandlerAdapter(InvocableHandlerMethod invokerHandlerMethod) {
        this.invokerHandlerMethod = invokerHandlerMethod;
        this.delegatingHandler = null;
    }

    public HandlerAdapter(DelegatingInvocableHandler delegatingHandler) {
        this.invokerHandlerMethod = null;
        this.delegatingHandler = delegatingHandler;
    }

    public @Nullable Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.invoke(message, providedArgs);
        }
        Assert.notNull((Object)this.delegatingHandler, () -> "invokerHandlerMethod and delegatingHandler are null - one must be specified");
        DelegatingInvocableHandler delegateHandler = this.delegatingHandler;
        if (delegateHandler.hasDefaultHandler()) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = message.getPayload();
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            return this.delegatingHandler.invoke(message, args);
        }
        return delegateHandler.invoke(message, providedArgs);
    }

    public String getMethodAsString(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().toGenericString();
        }
        Assert.notNull((Object)this.delegatingHandler, () -> "invokerHandlerMethod and delegatingHandler are null - one must be specified");
        return this.delegatingHandler.getMethodNameFor(payload);
    }

    public Object getBean() {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getBean();
        }
        Assert.notNull((Object)this.delegatingHandler, () -> "invokerHandlerMethod and delegatingHandler are null - one must be specified");
        return this.delegatingHandler.getBean();
    }

    private DelegatingInvocableHandler getRequiredDelegatingHandler() {
        Assert.notNull((Object)this.delegatingHandler, () -> "delegatingHandler must not be null");
        return this.delegatingHandler;
    }

    public @Nullable InvocableHandlerMethod getInvokerHandlerMethod() {
        return this.invokerHandlerMethod;
    }

    public InvocableHandlerMethod requireNonNullInvokerHandlerMethod() {
        Assert.notNull((Object)this.invokerHandlerMethod, () -> "invokerHandlerMethod must not be null");
        return this.invokerHandlerMethod;
    }
}

