/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.pulsar.config.StartupFailurePolicy;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.core.TransactionProperties;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.pulsar.observation.PulsarListenerObservationConvention;
import org.springframework.pulsar.transaction.PulsarAwareTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public class PulsarContainerProperties {
    private static final Duration DEFAULT_CONSUMER_START_TIMEOUT = Duration.ofSeconds(30L);
    private static final String SUBSCRIPTION_NAME = "subscriptionName";
    private static final String SUBSCRIPTION_TYPE = "subscriptionType";
    private @Nullable Duration consumerStartTimeout = DEFAULT_CONSUMER_START_TIMEOUT;
    private @Nullable Set<String> topics;
    private @Nullable String topicsPattern;
    private @Nullable String subscriptionName;
    private @Nullable SubscriptionType subscriptionType;
    private @Nullable Schema<?> schema;
    private @Nullable SchemaType schemaType;
    private @Nullable SchemaResolver schemaResolver;
    private @Nullable TopicResolver topicResolver;
    private @Nullable Object messageListener;
    private @Nullable AsyncTaskExecutor consumerTaskExecutor;
    private int concurrency = 1;
    private int maxNumMessages = -1;
    private int maxNumBytes = 0xA00000;
    private int batchTimeoutMillis = 100;
    private boolean batchListener;
    private @Nullable AckMode ackMode = AckMode.BATCH;
    private boolean observationEnabled;
    private @Nullable ObservationRegistry observationRegistry;
    private @Nullable PulsarListenerObservationConvention observationConvention;
    private Properties pulsarConsumerProperties = new Properties();
    private final TransactionSettings transactions = new TransactionSettings();
    private @Nullable RetryTemplate startupFailureRetryTemplate;
    private final RetryTemplate defaultStartupFailureRetryTemplate = new RetryTemplate(RetryPolicy.builder().backOff((BackOff)new FixedBackOff(Duration.ofSeconds(10L).toMillis(), 3L)).build());
    private StartupFailurePolicy startupFailurePolicy = StartupFailurePolicy.STOP;

    public PulsarContainerProperties(String ... topics) {
        this.topics = Set.of(topics);
        this.topicsPattern = null;
        this.schemaResolver = new DefaultSchemaResolver();
        this.topicResolver = new DefaultTopicResolver();
    }

    public PulsarContainerProperties(String topicPattern) {
        this.topicsPattern = topicPattern;
        this.topics = null;
        this.schemaResolver = new DefaultSchemaResolver();
        this.topicResolver = new DefaultTopicResolver();
    }

    public @Nullable Object getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(@Nullable Object messageListener) {
        this.messageListener = messageListener;
    }

    public @Nullable AsyncTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public void setConsumerTaskExecutor(@Nullable AsyncTaskExecutor consumerExecutor) {
        this.consumerTaskExecutor = consumerExecutor;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public @Nullable SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(@Nullable SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public int getMaxNumMessages() {
        return this.maxNumMessages;
    }

    public void setMaxNumMessages(int maxNumMessages) {
        this.maxNumMessages = maxNumMessages;
    }

    public int getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public void setMaxNumBytes(int maxNumBytes) {
        this.maxNumBytes = maxNumBytes;
    }

    public int getBatchTimeoutMillis() {
        return this.batchTimeoutMillis;
    }

    public void setBatchTimeoutMillis(int batchTimeoutMillis) {
        this.batchTimeoutMillis = batchTimeoutMillis;
    }

    public boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    public @Nullable AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(@Nullable AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isObservationEnabled() {
        return this.observationEnabled;
    }

    public void setObservationEnabled(boolean observationEnabled) {
        this.observationEnabled = observationEnabled;
    }

    public @Nullable ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    void setObservationRegistry(@Nullable ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public @Nullable PulsarListenerObservationConvention getObservationConvention() {
        return this.observationConvention;
    }

    void setObservationConvention(@Nullable PulsarListenerObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    public @Nullable Duration getConsumerStartTimeout() {
        return this.consumerStartTimeout;
    }

    public Duration determineConsumerStartTimeout() {
        return this.consumerStartTimeout != null ? this.consumerStartTimeout : DEFAULT_CONSUMER_START_TIMEOUT;
    }

    public void setConsumerStartTimeout(@Nullable Duration consumerStartTimeout) {
        this.consumerStartTimeout = consumerStartTimeout;
    }

    public @Nullable Set<String> getTopics() {
        return this.topics;
    }

    public void setTopics(@Nullable Set<String> topics) {
        this.topics = topics;
    }

    public @Nullable String getTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(@Nullable String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public @Nullable String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(@Nullable String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public @Nullable Schema<?> getSchema() {
        return this.schema;
    }

    public void setSchema(@Nullable Schema<?> schema) {
        this.schema = schema;
    }

    public @Nullable SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(@Nullable SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public @Nullable SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(@Nullable SchemaResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public @Nullable TopicResolver getTopicResolver() {
        return this.topicResolver;
    }

    public void setTopicResolver(@Nullable TopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    public Properties getPulsarConsumerProperties() {
        return this.pulsarConsumerProperties;
    }

    public void setPulsarConsumerProperties(Properties pulsarConsumerProperties) {
        Assert.notNull((Object)pulsarConsumerProperties, (String)"pulsarConsumerProperties must not be null");
        this.pulsarConsumerProperties = pulsarConsumerProperties;
    }

    public TransactionSettings transactions() {
        return this.transactions;
    }

    public @Nullable RetryTemplate getStartupFailureRetryTemplate() {
        return this.startupFailureRetryTemplate;
    }

    public RetryTemplate getDefaultStartupFailureRetryTemplate() {
        return this.defaultStartupFailureRetryTemplate;
    }

    public void setStartupFailureRetryTemplate(@Nullable RetryTemplate startupFailureRetryTemplate) {
        this.startupFailureRetryTemplate = startupFailureRetryTemplate;
        if (this.startupFailureRetryTemplate != null) {
            this.setStartupFailurePolicy(StartupFailurePolicy.RETRY);
        }
    }

    public @Nullable StartupFailurePolicy getStartupFailurePolicy() {
        return this.startupFailurePolicy;
    }

    public void setStartupFailurePolicy(@Nullable StartupFailurePolicy startupFailurePolicy) {
        this.startupFailurePolicy = Objects.requireNonNull(startupFailurePolicy, "startupFailurePolicy must not be null");
    }

    public void updateContainerProperties() {
        this.applyPropIfSpecified(SUBSCRIPTION_NAME, this::setSubscriptionName);
        this.applyPropIfSpecified(SUBSCRIPTION_TYPE, this::setSubscriptionType);
    }

    private <T> void applyPropIfSpecified(String key, Consumer<T> setter) {
        if (this.pulsarConsumerProperties.containsKey(key)) {
            Object value = this.pulsarConsumerProperties.get(key);
            setter.accept(value);
        }
    }

    public static class TransactionSettings
    extends TransactionProperties {
        private @Nullable TransactionDefinition transactionDefinition;
        private @Nullable PulsarAwareTransactionManager transactionManager;

        public @Nullable TransactionDefinition getTransactionDefinition() {
            return this.transactionDefinition;
        }

        public void setTransactionDefinition(@Nullable TransactionDefinition transactionDefinition) {
            this.transactionDefinition = transactionDefinition;
        }

        public @Nullable TransactionDefinition determineTransactionDefinition() {
            Duration timeout = this.getTimeout();
            if (timeout == null) {
                return this.transactionDefinition;
            }
            DefaultTransactionDefinition txnDef = this.transactionDefinition != null ? new DefaultTransactionDefinition(this.transactionDefinition) : new DefaultTransactionDefinition();
            txnDef.setTimeout(Math.toIntExact(timeout.toSeconds()));
            return txnDef;
        }

        public @Nullable PulsarAwareTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public void setTransactionManager(@Nullable PulsarAwareTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }
    }
}

