/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractPulsarListenerEndpoint<K>
implements PulsarListenerEndpoint,
BeanFactoryAware,
InitializingBean {
    private @Nullable String subscriptionName;
    private @Nullable SubscriptionType subscriptionType;
    private @Nullable SchemaType schemaType;
    private @Nullable String id;
    private final Collection<String> topics = new ArrayList<String>();
    private @Nullable String topicPattern;
    private @Nullable BeanFactory beanFactory;
    private @Nullable BeanExpressionResolver resolver;
    private @Nullable BeanExpressionContext expressionContext;
    private @Nullable BeanResolver beanResolver;
    private @Nullable Boolean autoStartup;
    private @Nullable Properties consumerProperties;
    private @Nullable Boolean batchListener;
    private @Nullable Integer concurrency;
    private @Nullable AckMode ackMode;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    protected @Nullable BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        if (!topicsEmpty && !StringUtils.hasText((String)this.getTopicPattern())) {
            throw new IllegalStateException("Topics or topicPattern must be provided but not both for " + String.valueOf(this));
        }
    }

    protected @Nullable BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected @Nullable BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    protected @Nullable BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setSubscriptionName(@Nullable String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Override
    public @Nullable String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public @Nullable String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(this.topics);
    }

    public void setTopicPattern(@Nullable String topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public @Nullable String getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    public @Nullable Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(@Nullable Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public void setupListenerContainer(PulsarMessageListenerContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    private void setupMessageListener(PulsarMessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<K> messageListener = this.createMessageListener(container, messageConverter);
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + String.valueOf(this) + "] must provide a non null message listener");
        container.setupMessageListener(messageListener);
    }

    protected abstract AbstractPulsarMessageToSpringMessageAdapter<K> createMessageListener(PulsarMessageListenerContainer var1, @Nullable MessageConverter var2);

    public void setConsumerProperties(@Nullable Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    @Override
    public @Nullable Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public @Nullable Boolean getBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    @Override
    public boolean isBatchListener() {
        return this.batchListener == null ? false : this.batchListener;
    }

    @Override
    public @Nullable SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    @Override
    public @Nullable SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    @Override
    public @Nullable Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public @Nullable AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }
}

