/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.GenericReaderEndpointRegistry;
import org.springframework.pulsar.config.ListenerContainerFactory;
import org.springframework.pulsar.config.PulsarReaderEndpoint;
import org.springframework.pulsar.config.ReaderContainerFactory;
import org.springframework.util.Assert;

public class PulsarReaderEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    private final Class<? extends ReaderContainerFactory> type;
    private final List<PulsarReaderEndpointDescriptor> endpointDescriptors = new ArrayList<PulsarReaderEndpointDescriptor>();
    private final ReentrantLock endpointDescriptorsLock = new ReentrantLock();
    private GenericReaderEndpointRegistry endpointRegistry;
    private ReaderContainerFactory<?, ?> containerFactory;
    private String containerFactoryBeanName;
    private BeanFactory beanFactory;
    private boolean startImmediately;

    public PulsarReaderEndpointRegistrar(Class<? extends ReaderContainerFactory> type) {
        this.type = type;
    }

    public void setEndpointRegistry(GenericReaderEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    @Nullable
    public GenericReaderEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setContainerFactory(ReaderContainerFactory<?, ?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        this.endpointDescriptorsLock.lock();
        try {
            for (PulsarReaderEndpointDescriptor descriptor : this.endpointDescriptors) {
                ReaderContainerFactory<?, ?> factory = this.resolveContainerFactory(descriptor);
                this.endpointRegistry.registerReaderContainer(descriptor.endpoint, factory);
            }
            this.startImmediately = true;
        }
        finally {
            this.endpointDescriptorsLock.unlock();
        }
    }

    private ReaderContainerFactory<?, ?> resolveContainerFactory(PulsarReaderEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (ReaderContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, this.type);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + ListenerContainerFactory.class.getSimpleName() + " to use for [" + String.valueOf(descriptor.endpoint) + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(PulsarReaderEndpoint endpoint, @Nullable ReaderContainerFactory<?, ?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must be set");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        PulsarReaderEndpointDescriptor descriptor = new PulsarReaderEndpointDescriptor(endpoint, factory);
        this.endpointDescriptorsLock.lock();
        try {
            if (this.startImmediately) {
                this.endpointRegistry.registerReaderContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
        finally {
            this.endpointDescriptorsLock.unlock();
        }
    }

    private static final class PulsarReaderEndpointDescriptor {
        private final PulsarReaderEndpoint endpoint;
        private final ReaderContainerFactory<?, ?> containerFactory;

        private PulsarReaderEndpointDescriptor(PulsarReaderEndpoint endpoint, @Nullable ReaderContainerFactory<?, ?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

