/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.transaction;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.transaction.PulsarResourceHolder;
import org.springframework.pulsar.transaction.PulsarResourceSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class PulsarTransactionUtils {
    private static final LogAccessor LOG = new LogAccessor(PulsarTransactionUtils.class);

    private PulsarTransactionUtils() {
    }

    public static boolean inTransaction(PulsarClient pulsarClient) {
        return TransactionSynchronizationManager.getResource((Object)pulsarClient) != null || TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static void abort(Transaction transaction) {
        Assert.notNull((Object)transaction, (String)"transaction must not be null");
        LOG.trace(() -> "Aborting Pulsar txn [%s]...".formatted(transaction));
        transaction.abort().whenComplete((__, ex) -> {
            if (ex != null) {
                LOG.error(ex, () -> "Failed to abort Pulsar txn [%s] due to: %s".formatted(transaction, ex.getMessage()));
            } else {
                LOG.trace(() -> "Completed abort of Pulsar txn [%s]".formatted(transaction));
            }
        });
    }

    @Nullable
    public static PulsarResourceHolder getResourceHolder(PulsarClient pulsarClient) {
        return (PulsarResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)pulsarClient));
    }

    public static PulsarResourceHolder obtainResourceHolder(PulsarClient pulsarClient, @Nullable Duration timeout) {
        Assert.notNull((Object)pulsarClient, (String)"pulsarClient must not be null");
        PulsarResourceHolder resourceHolder = PulsarTransactionUtils.getResourceHolder(pulsarClient);
        if (resourceHolder != null) {
            LOG.trace(() -> "Found already bound Pulsar txn resource " + String.valueOf((Object)resourceHolder));
            return resourceHolder;
        }
        Transaction pulsarTxn = PulsarTransactionUtils.createPulsarTransaction(pulsarClient, timeout);
        PulsarResourceHolder newResourceHolder = new PulsarResourceHolder(pulsarTxn);
        LOG.trace(() -> "Created Pulsar txn resource " + String.valueOf((Object)newResourceHolder));
        if (timeout != null) {
            newResourceHolder.setTimeoutInSeconds(Math.toIntExact(timeout.toSeconds()));
        }
        PulsarTransactionUtils.bindResourceToTransaction(pulsarClient, newResourceHolder);
        return newResourceHolder;
    }

    private static Transaction createPulsarTransaction(PulsarClient pulsarClient, @Nullable Duration timeout) {
        try {
            TransactionBuilder txnBuilder = pulsarClient.newTransaction();
            if (timeout != null) {
                txnBuilder.withTransactionTimeout(timeout.toSeconds() + 1L, TimeUnit.SECONDS);
            }
            return (Transaction)txnBuilder.build().get();
        }
        catch (Exception ex) {
            throw PulsarException.unwrap(ex);
        }
    }

    private static <K, V> void bindResourceToTransaction(PulsarClient pulsarClient, PulsarResourceHolder resourceHolder) {
        TransactionSynchronizationManager.bindResource((Object)pulsarClient, (Object)((Object)resourceHolder));
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new PulsarResourceSynchronization(resourceHolder, pulsarClient));
            LOG.debug(() -> "Registered synchronization for Pulsar txn resource " + String.valueOf((Object)resourceHolder));
        }
    }
}

