/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.transaction;

import java.time.Duration;
import org.apache.pulsar.client.api.PulsarClient;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.transaction.PulsarAwareTransactionManager;
import org.springframework.pulsar.transaction.PulsarResourceHolder;
import org.springframework.pulsar.transaction.PulsarTransactionObject;
import org.springframework.pulsar.transaction.PulsarTransactionUtils;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class PulsarTransactionManager
extends AbstractPlatformTransactionManager
implements PulsarAwareTransactionManager {
    private static final LogAccessor LOG = new LogAccessor(PulsarTransactionManager.class);
    private final PulsarClient pulsarClient;

    public PulsarTransactionManager(PulsarClient pulsarClient) {
        Assert.notNull((Object)pulsarClient, (String)"pulsarClient must not be null");
        this.pulsarClient = pulsarClient;
        this.setTransactionSynchronization(2);
    }

    @Override
    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }

    protected Object doGetTransaction() {
        Object resourceHolder = TransactionSynchronizationManager.getResource((Object)this.pulsarClient);
        PulsarTransactionObject txObject = new PulsarTransactionObject();
        txObject.setResourceHolder((PulsarResourceHolder)((Object)this.cast(resourceHolder)));
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        PulsarTransactionObject txObject = this.asPulsarTxObject(transaction);
        return txObject.getResourceHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Apache Pulsar does not support an isolation level concept");
        }
        try {
            int timeoutSeconds = this.determineTimeout(definition);
            PulsarResourceHolder resourceHolder = PulsarTransactionUtils.obtainResourceHolder(this.pulsarClient, timeoutSeconds != -1 ? Duration.ofSeconds(timeoutSeconds) : null);
            LOG.debug(() -> "Created Pulsar transaction on [%s]".formatted(resourceHolder.getTransaction()));
            resourceHolder.setSynchronizedWithTransaction(true);
            PulsarTransactionObject txObject = this.asPulsarTxObject(transaction);
            txObject.setResourceHolder(resourceHolder);
        }
        catch (Exception ex) {
            throw new CannotCreateTransactionException("Could not create Pulsar transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        PulsarTransactionObject txObject = this.asPulsarTxObject(transaction);
        txObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.pulsarClient);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.pulsarClient, (Object)suspendedResources);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        this.asPulsarTxObject(status.getTransaction()).getResourceHolder().commit();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.asPulsarTxObject(status.getTransaction()).getResourceHolder().rollback();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        this.asPulsarTxObject(status.getTransaction()).getResourceHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        PulsarTransactionObject txObject = this.asPulsarTxObject(transaction);
        TransactionSynchronizationManager.unbindResource((Object)this.pulsarClient);
        txObject.getResourceHolder().clear();
    }

    private <X> X cast(Object raw) {
        return (X)raw;
    }

    private PulsarTransactionObject asPulsarTxObject(Object rawTxObject) {
        return (PulsarTransactionObject)PulsarTransactionObject.class.cast(rawTxObject);
    }
}

