/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.transaction;

import org.apache.pulsar.client.api.transaction.Transaction;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.transaction.PulsarTransactionUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class PulsarResourceHolder
extends ResourceHolderSupport {
    private static final LogAccessor LOG = new LogAccessor(PulsarResourceHolder.class);
    private final Transaction transaction;
    private boolean committed;

    public PulsarResourceHolder(Transaction transaction) {
        Assert.notNull((Object)transaction, (String)"transaction must not be null");
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void commit() {
        if (!this.committed) {
            LOG.trace(() -> "Committing Pulsar txn [%s]...".formatted(this.transaction));
            try {
                this.transaction.commit().get();
            }
            catch (Exception e) {
                throw PulsarException.unwrap(e);
            }
            LOG.trace(() -> "Committed Pulsar txn [%s]".formatted(this.transaction));
            this.committed = true;
        } else {
            LOG.trace(() -> "Skipping request to commit - already committed");
        }
    }

    public void rollback() {
        LOG.trace(() -> "Rolling back Pulsar txn [%s]...".formatted(this.transaction));
        PulsarTransactionUtils.abort(this.transaction);
    }

    public String toString() {
        return "PulsarResourceHolder{transaction=%s, committed=%s}".formatted(this.transaction, this.committed);
    }
}

