/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.converter;

import java.lang.reflect.Type;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.pulsar.support.header.PulsarHeaderMapper;

public class PulsarRecordMessageConverter<V>
implements PulsarMessageConverter<V> {
    private final PulsarHeaderMapper headerMapper;
    private SmartMessageConverter messagingConverter;

    public PulsarRecordMessageConverter(PulsarHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    @Override
    public org.springframework.messaging.Message<?> toMessage(Message<V> record, Consumer<V> consumer, Type type) {
        return MessageBuilder.createMessage((Object)this.extractAndConvertValue(record), (MessageHeaders)this.headerMapper.toSpringHeaders(record));
    }

    protected MessageConverter getMessagingConverter() {
        return this.messagingConverter;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    protected Object extractAndConvertValue(Message<V> record) {
        return record.getValue();
    }
}

