/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener.adapter;

import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.listener.adapter.DelegatingInvocableHandler;

public class HandlerAdapter {
    private final InvocableHandlerMethod invokerHandlerMethod;
    private final DelegatingInvocableHandler delegatingHandler;

    public HandlerAdapter(InvocableHandlerMethod invokerHandlerMethod) {
        this.invokerHandlerMethod = invokerHandlerMethod;
        this.delegatingHandler = null;
    }

    public HandlerAdapter(DelegatingInvocableHandler delegatingHandler) {
        this.invokerHandlerMethod = null;
        this.delegatingHandler = delegatingHandler;
    }

    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.invoke(message, providedArgs);
        }
        if (this.delegatingHandler.hasDefaultHandler()) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = message.getPayload();
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            return this.delegatingHandler.invoke(message, args);
        }
        return this.delegatingHandler.invoke(message, providedArgs);
    }

    public String getMethodAsString(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().toGenericString();
        }
        return this.delegatingHandler.getMethodNameFor(payload);
    }

    public Object getBean() {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getBean();
        }
        return this.delegatingHandler.getBean();
    }

    public InvocableHandlerMethod getInvokerHandlerMethod() {
        return this.invokerHandlerMethod;
    }
}

