/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.converter;

import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.pulsar.support.PulsarMessageHeaderMapper;
import org.springframework.pulsar.support.converter.PulsarRecordMessageConverter;

public class PulsarMessagingMessageConverter<V>
implements PulsarRecordMessageConverter<V> {
    private final PulsarMessageHeaderMapper pulsarMessageHeaderMapper;
    private SmartMessageConverter messagingConverter;

    public PulsarMessagingMessageConverter(PulsarMessageHeaderMapper pulsarMessageHeaderMapper) {
        this.pulsarMessageHeaderMapper = pulsarMessageHeaderMapper;
    }

    @Override
    public org.springframework.messaging.Message<?> toMessage(Message<V> record, Consumer<V> consumer, Type type) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        this.pulsarMessageHeaderMapper.toHeaders(record, messageHeaders);
        org.springframework.messaging.Message message = MessageBuilder.createMessage((Object)this.extractAndConvertValue(record), (MessageHeaders)new MessageHeaders(messageHeaders));
        return message;
    }

    @Override
    public V fromMessage(org.springframework.messaging.Message<?> messageArg, String defaultTopic) {
        org.springframework.messaging.Message converted;
        org.springframework.messaging.Message message = messageArg;
        if (this.messagingConverter != null && (converted = this.messagingConverter.toMessage(message.getPayload(), message.getHeaders())) != null) {
            message = converted;
        }
        return null;
    }

    protected MessageConverter getMessagingConverter() {
        return this.messagingConverter;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    protected Object extractAndConvertValue(Message<V> record) {
        return record.getValue();
    }
}

