/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.pulsar.support.converter.PulsarBatchMessageConverter;
import org.springframework.pulsar.support.converter.PulsarRecordMessageConverter;

public class PulsarBatchMessagingMessageConverter<T>
implements PulsarBatchMessageConverter<T> {
    private final PulsarRecordMessageConverter<T> recordConverter;

    public PulsarBatchMessagingMessageConverter() {
        this(null);
    }

    public PulsarBatchMessagingMessageConverter(PulsarRecordMessageConverter<T> recordConverter) {
        this.recordConverter = recordConverter;
    }

    @Override
    public org.springframework.messaging.Message<?> toMessage(List<Message<T>> records, Consumer<T> consumer, Type type) {
        ArrayList<Object> payloads = new ArrayList<Object>();
        ArrayList<Exception> conversionFailures = new ArrayList<Exception>();
        for (Message<T> message : records) {
            payloads.add(this.obtainPayload(type, message, conversionFailures));
        }
        return MessageBuilder.createMessage(payloads, (MessageHeaders)new MessageHeaders(Collections.emptyMap()));
    }

    private Object obtainPayload(Type type, Message<T> record, List<Exception> conversionFailures) {
        return this.recordConverter == null || !this.containerType(type) ? this.extractAndConvertValue(record, type) : this.convert(record, type, conversionFailures);
    }

    private boolean containerType(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1;
    }

    protected Object extractAndConvertValue(Message<T> record, Type type) {
        return record.getValue();
    }

    protected Object convert(Message<T> record, Type type, List<Exception> conversionFailures) {
        try {
            Object payload = this.recordConverter.toMessage(record, null, ((ParameterizedType)type).getActualTypeArguments()[0]).getPayload();
            conversionFailures.add(null);
            return payload;
        }
        catch (Exception ex) {
            throw new RuntimeException("The batch converter can only report conversion failures to the listener if the record.value() is byte[], Bytes, or String", ex);
        }
    }

    @Override
    public T fromMessage(Messages<T> message, String defaultTopic) {
        throw new UnsupportedOperationException();
    }
}

