/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.AbstractPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.DefaultPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.util.Assert;

public class ConcurrentPulsarMessageListenerContainer<T>
extends AbstractPulsarMessageListenerContainer<T> {
    private final List<DefaultPulsarMessageListenerContainer<T>> containers = new ArrayList<DefaultPulsarMessageListenerContainer<T>>();
    private int concurrency = 1;
    private final List<AsyncTaskExecutor> executors = new ArrayList<AsyncTaskExecutor>();

    public ConcurrentPulsarMessageListenerContainer(PulsarConsumerFactory<? super T> pulsarConsumerFactory, PulsarContainerProperties pulsarContainerProperties, @Nullable ObservationRegistry observationRegistry) {
        super(pulsarConsumerFactory, pulsarContainerProperties, observationRegistry);
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        Assert.isTrue((concurrency > 0 ? 1 : 0) != 0, (String)"concurrency must be greater than 0");
        this.concurrency = concurrency;
    }

    @Override
    public void doStart() {
        if (!this.isRunning()) {
            PulsarContainerProperties containerProperties = this.getContainerProperties();
            if (containerProperties.getSubscriptionType() == SubscriptionType.Exclusive && this.concurrency > 1) {
                throw new IllegalStateException("concurrency > 1 is not allowed on Exclusive subscription type");
            }
            this.setRunning(true);
            for (int i = 0; i < this.concurrency; ++i) {
                DefaultPulsarMessageListenerContainer<T> container = this.constructContainer(containerProperties);
                this.configureChildContainer(i, container);
                container.start();
                this.containers.add(container);
            }
        }
    }

    private DefaultPulsarMessageListenerContainer<T> constructContainer(PulsarContainerProperties containerProperties) {
        return new DefaultPulsarMessageListenerContainer(this.getPulsarConsumerFactory(), containerProperties, this.getObservationRegistry());
    }

    private void configureChildContainer(int index, DefaultPulsarMessageListenerContainer<T> container) {
        AsyncTaskExecutor exec;
        ApplicationEventPublisher publisher;
        Object beanName = this.getBeanName();
        beanName = (String)(beanName == null ? "consumer" : beanName) + "-" + index;
        container.setBeanName((String)beanName);
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            container.setApplicationContext(applicationContext);
        }
        if ((publisher = this.getApplicationEventPublisher()) != null) {
            container.setApplicationEventPublisher(publisher);
        }
        if ((exec = container.getContainerProperties().getConsumerTaskExecutor()) == null) {
            exec = new SimpleAsyncTaskExecutor((String)beanName + "-C-");
            this.executors.add(exec);
            container.getContainerProperties().setConsumerTaskExecutor(exec);
        }
        container.setNegativeAckRedeliveryBackoff(this.negativeAckRedeliveryBackoff);
        container.setAckTimeoutRedeliveryBackoff(this.ackTimeoutRedeliveryBackoff);
        container.setDeadLetterPolicy(this.deadLetterPolicy);
        container.setPulsarConsumerErrorHandler(this.pulsarConsumerErrorHandler);
    }

    @Override
    public void doStop() {
        if (this.isRunning()) {
            this.setRunning(false);
            for (DefaultPulsarMessageListenerContainer<T> pulsarMessageListenerContainer : this.containers) {
                pulsarMessageListenerContainer.stop();
            }
            this.containers.clear();
        }
    }

    public List<DefaultPulsarMessageListenerContainer<T>> getContainers() {
        return this.containers;
    }
}

