/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Optional;
import org.apache.pulsar.client.api.Producer;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.util.StringUtils;

final class ProducerUtils {
    private ProducerUtils() {
    }

    static <T> String formatProducer(Producer<T> producer) {
        return String.format("(%s:%s)", producer.getProducerName(), producer.getTopic());
    }

    static <T> String resolveTopicName(@Nullable String userSpecifiedTopic, PulsarProducerFactory<T> producerFactory) {
        if (StringUtils.hasText((String)userSpecifiedTopic)) {
            return userSpecifiedTopic;
        }
        return Optional.ofNullable(producerFactory.getProducerConfig().get("topicName")).map(Object::toString).orElseThrow(() -> new IllegalArgumentException("Topic must be specified when no default topic is configured"));
    }

    static <T> void closeProducerAsync(Producer<T> producer, LogAccessor logger) {
        producer.closeAsync().exceptionally(e -> {
            logger.warn(e, () -> String.format("Failed to close producer %s", ProducerUtils.formatProducer(producer)));
            return null;
        });
    }
}

