/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.ProtobufSchema;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.config.AbstractPulsarListenerEndpoint;
import org.springframework.pulsar.core.SchemaUtils;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarBatchMessagingMessageListenerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarMessagingMessageListenerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarRecordMessagingMessageListenerAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarBatchMessageConverter;
import org.springframework.pulsar.support.converter.PulsarRecordMessageConverter;
import org.springframework.util.Assert;

public class MethodPulsarListenerEndpoint<V>
extends AbstractPulsarListenerEndpoint<V> {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private SmartMessageConverter messagingConverter;
    private RedeliveryBackoff negativeAckRedeliveryBackoff;
    private RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    private DeadLetterPolicy deadLetterPolicy;
    private PulsarConsumerErrorHandler pulsarConsumerErrorHandler;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Override
    protected PulsarMessagingMessageListenerAdapter<V> createMessageListener(PulsarMessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        Schema<?> messageSchema;
        ConcurrentPulsarMessageListenerContainer containerInstance;
        PulsarContainerProperties pulsarContainerProperties;
        SchemaType schemaType;
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        PulsarMessagingMessageListenerAdapter<V> messageListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(messageListener);
        messageListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.getInvokerHandlerMethod().getMethodParameters();
        MethodParameter messageParameter = null;
        Optional<MethodParameter> parameter = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) || !methodParameter1.getParameterType().equals(Acknowledgement.class) || !methodParameter1.hasParameterAnnotation(Header.class)).findFirst();
        long count = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) && !methodParameter1.getParameterType().equals(Acknowledgement.class) && !methodParameter1.hasParameterAnnotation(Header.class)).count();
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"More than 1 expected payload types found");
        if (parameter.isPresent()) {
            messageParameter = parameter.get();
        }
        if ((schemaType = (pulsarContainerProperties = (containerInstance = (ConcurrentPulsarMessageListenerContainer)container).getContainerProperties()).getSchemaType()) != SchemaType.NONE) {
            switch (schemaType) {
                case STRING: {
                    pulsarContainerProperties.setSchema(Schema.STRING);
                    break;
                }
                case BYTES: {
                    pulsarContainerProperties.setSchema(Schema.BYTES);
                    break;
                }
                case INT8: {
                    pulsarContainerProperties.setSchema(Schema.INT8);
                    break;
                }
                case INT16: {
                    pulsarContainerProperties.setSchema(Schema.INT16);
                    break;
                }
                case INT32: {
                    pulsarContainerProperties.setSchema(Schema.INT32);
                    break;
                }
                case INT64: {
                    pulsarContainerProperties.setSchema(Schema.INT64);
                    break;
                }
                case BOOLEAN: {
                    pulsarContainerProperties.setSchema(Schema.BOOL);
                    break;
                }
                case DATE: {
                    pulsarContainerProperties.setSchema(Schema.DATE);
                    break;
                }
                case DOUBLE: {
                    pulsarContainerProperties.setSchema(Schema.DOUBLE);
                    break;
                }
                case FLOAT: {
                    pulsarContainerProperties.setSchema(Schema.FLOAT);
                    break;
                }
                case INSTANT: {
                    pulsarContainerProperties.setSchema(Schema.INSTANT);
                    break;
                }
                case LOCAL_DATE: {
                    pulsarContainerProperties.setSchema(Schema.LOCAL_DATE);
                    break;
                }
                case LOCAL_DATE_TIME: {
                    pulsarContainerProperties.setSchema(Schema.LOCAL_DATE_TIME);
                    break;
                }
                case LOCAL_TIME: {
                    pulsarContainerProperties.setSchema(Schema.LOCAL_TIME);
                    break;
                }
                case JSON: {
                    messageSchema = this.getMessageSchema(messageParameter, JSONSchema::of);
                    pulsarContainerProperties.setSchema(messageSchema);
                    break;
                }
                case AVRO: {
                    messageSchema = this.getMessageSchema(messageParameter, AvroSchema::of);
                    pulsarContainerProperties.setSchema(messageSchema);
                    break;
                }
                case PROTOBUF: {
                    messageSchema = this.getMessageSchema(messageParameter, c -> ProtobufSchema.of((Class)c));
                    pulsarContainerProperties.setSchema(messageSchema);
                    break;
                }
                case KEY_VALUE: {
                    messageSchema = this.getMessageKeyValueSchema(messageParameter);
                    pulsarContainerProperties.setSchema(messageSchema);
                }
            }
        } else if (messageParameter != null && (messageSchema = this.getMessageSchema(messageParameter, messageClass -> SchemaUtils.getSchema(messageClass, false))) != null) {
            pulsarContainerProperties.setSchema(messageSchema);
        }
        SchemaType type = pulsarContainerProperties.getSchema().getSchemaInfo().getType();
        pulsarContainerProperties.setSchemaType(type);
        container.setNegativeAckRedeliveryBackoff(this.negativeAckRedeliveryBackoff);
        container.setAckTimeoutRedeliveryBackoff(this.ackTimeoutRedeliveryBackoff);
        container.setDeadLetterPolicy(this.deadLetterPolicy);
        container.setPulsarConsumerErrorHandler(this.pulsarConsumerErrorHandler);
        return messageListener;
    }

    private Schema<?> getMessageSchema(MethodParameter messageParameter, Function<Class<?>, Schema<?>> schemaFactory) {
        ResolvableType messageType = this.resolvableType(messageParameter);
        Class messageClass = messageType.getRawClass();
        return schemaFactory.apply(messageClass);
    }

    private Schema<?> getMessageKeyValueSchema(MethodParameter messageParameter) {
        ResolvableType messageType = this.resolvableType(messageParameter);
        Class keyClass = messageType.resolveGeneric(new int[]{0});
        Class valueClass = messageType.resolveGeneric(new int[]{1});
        Schema keySchema = SchemaUtils.getSchema(keyClass);
        Schema valueSchema = SchemaUtils.getSchema(valueClass);
        return Schema.KeyValue(keySchema, valueSchema, (KeyValueEncodingType)KeyValueEncodingType.INLINE);
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass())) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(PulsarMessagingMessageListenerAdapter<V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected PulsarMessagingMessageListenerAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        PulsarMessagingMessageListenerAdapter listener;
        if (this.isBatchListener()) {
            messageListener = new PulsarBatchMessagingMessageListenerAdapter(this.bean, this.method);
            if (messageConverter instanceof PulsarBatchMessageConverter) {
                ((PulsarBatchMessagingMessageListenerAdapter)messageListener).setBatchMessageConverter((PulsarBatchMessageConverter)messageConverter);
            }
            listener = messageListener;
        } else {
            messageListener = new PulsarRecordMessagingMessageListenerAdapter(this.bean, this.method);
            if (messageConverter instanceof PulsarRecordMessageConverter) {
                messageListener.setMessageConverter((PulsarRecordMessageConverter)messageConverter);
            }
            listener = messageListener;
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public void setPulsarConsumerErrorHandler(PulsarConsumerErrorHandler pulsarConsumerErrorHandler) {
        this.pulsarConsumerErrorHandler = pulsarConsumerErrorHandler;
    }

    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
    }
}

