/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.commons.logging.LogFactory;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.log.LogAccessor;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.annotation.PulsarListener;
import org.springframework.pulsar.annotation.PulsarListenerConfigurer;
import org.springframework.pulsar.annotation.PulsarListeners;
import org.springframework.pulsar.config.MethodPulsarListenerEndpoint;
import org.springframework.pulsar.config.PulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpointRegistrar;
import org.springframework.pulsar.config.PulsarListenerEndpointRegistry;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PulsarListenerAnnotationBeanPostProcessor<V>
implements BeanPostProcessor,
Ordered,
ApplicationContextAware,
InitializingBean,
SmartInitializingSingleton {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    public static final String DEFAULT_PULSAR_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "pulsarListenerContainerFactory";
    private static final String THE_LEFT = "The [";
    private static final String RESOLVED_TO_LEFT = "Resolved to [";
    private static final String RIGHT_FOR_LEFT = "] for [";
    private static final String GENERATED_ID_PREFIX = "org.springframework.Pulsar.PulsarListenerEndpointContainer#";
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private PulsarListenerEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "pulsarListenerContainerFactory";
    private final PulsarListenerEndpointRegistrar registrar = new PulsarListenerEndpointRegistrar(PulsarListenerContainerFactory.class);
    private final PulsarHandlerMethodFactoryAdapter messageHandlerMethodFactory = new PulsarHandlerMethodFactoryAdapter();
    private Charset charset = StandardCharsets.UTF_8;
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final ListenerScope listenerScope = new ListenerScope();
    private AnnotationEnhancer enhancer;
    private final AtomicInteger counter = new AtomicInteger();

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() {
        this.buildEnhancer();
    }

    private void buildEnhancer() {
        List enhancers;
        if (this.applicationContext != null && !(enhancers = this.applicationContext.getBeanProvider(AnnotationEnhancer.class, false).orderedStream().toList()).isEmpty()) {
            this.enhancer = (attrs, element) -> {
                for (AnnotationEnhancer enh : enhancers) {
                    attrs = (Map)enh.apply(attrs, element);
                }
                return attrs;
            };
        }
    }

    public void afterSingletonsInstantiated() {
        this.registrar.setBeanFactory(this.beanFactory);
        this.beanFactory.getBeanProvider(PulsarListenerConfigurer.class).forEach(c -> c.configurePulsarListeners(this.registrar));
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (PulsarListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.pulsar.config.internalPulsarListenerEndpointRegistry", PulsarListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        this.addFormatters((FormatterRegistry)this.messageHandlerMethodFactory.defaultFormattingConversionService);
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<PulsarListener> listenerMethods = this.findListenerAnnotations(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                this.logger.trace(() -> "No @PulsarListener annotations found on bean type: " + bean.getClass());
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (PulsarListener listener : (Set)entry.getValue()) {
                        this.processPulsarListener(listener, method2, bean, beanName);
                    }
                }
                this.logger.debug(() -> annotatedMethods.size() + " @PulsarListener methods processed on bean '" + beanName + "': " + annotatedMethods);
            }
        }
        return bean;
    }

    protected void processPulsarListener(PulsarListener pulsarListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodPulsarListenerEndpoint endpoint = new MethodPulsarListenerEndpoint();
        endpoint.setMethod(methodToUse);
        String beanRef = pulsarListener.beanRef();
        this.listenerScope.addListener(beanRef, bean);
        String[] topics = this.resolveTopics(pulsarListener);
        String topicPattern = this.getTopicPattern(pulsarListener);
        this.processListener(endpoint, pulsarListener, bean, beanName, topics, topicPattern);
        this.listenerScope.removeListener(beanRef);
    }

    protected void processListener(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener PulsarListener2, Object bean, String beanName, String[] topics, String topicPattern) {
        this.processPulsarListenerAnnotation(endpoint, PulsarListener2, bean, topics, topicPattern);
        String containerFactory = this.resolve(PulsarListener2.containerFactory());
        PulsarListenerContainerFactory listenerContainerFactory = this.resolveContainerFactory(PulsarListener2, containerFactory, beanName);
        this.registrar.registerEndpoint(endpoint, listenerContainerFactory);
    }

    @Nullable
    private PulsarListenerContainerFactory resolveContainerFactory(PulsarListener PulsarListener2, Object factoryTarget, String beanName) {
        String containerFactory = PulsarListener2.containerFactory();
        if (!StringUtils.hasText((String)containerFactory)) {
            return null;
        }
        PulsarListenerContainerFactory factory = null;
        Object resolved = this.resolveExpression(containerFactory);
        if (resolved instanceof PulsarListenerContainerFactory) {
            return (PulsarListenerContainerFactory)resolved;
        }
        String containerFactoryBeanName = this.resolveExpressionAsString(containerFactory, "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (PulsarListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, PulsarListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, PulsarListenerContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    protected void assertBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
    }

    protected String noBeanFoundMessage(Object target, String listenerBeanName, String requestedBeanName, Class<?> expectedClass) {
        return "Could not register Pulsar listener endpoint on [" + target + "] for bean " + listenerBeanName + ", no '" + expectedClass.getSimpleName() + "' with id '" + requestedBeanName + "' was found in the application context";
    }

    private void processPulsarListenerAnnotation(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener, Object bean, String[] topics, String topicPattern) {
        String autoStartup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setSubscriptionName(this.getEndpointSubscriptionName(pulsarListener));
        endpoint.setId(this.getEndpointId(pulsarListener));
        endpoint.setTopics(topics);
        endpoint.setTopicPattern(topicPattern);
        endpoint.setSubscriptionType(pulsarListener.subscriptionType());
        endpoint.setSchemaType(pulsarListener.schemaType());
        endpoint.setAckMode(pulsarListener.ackMode());
        String concurrency = pulsarListener.concurrency();
        if (StringUtils.hasText((String)concurrency)) {
            endpoint.setConcurrency(this.resolveExpressionAsInteger(concurrency, "concurrency"));
        }
        if (StringUtils.hasText((String)(autoStartup = pulsarListener.autoStartup()))) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup, "autoStartup"));
        }
        this.resolvePulsarProperties(endpoint, pulsarListener.properties());
        endpoint.setBatchListener(pulsarListener.batch());
        endpoint.setBeanFactory(this.beanFactory);
        this.resolveNegativeAckRedeliveryBackoff(endpoint, pulsarListener);
        this.resolveAckTimeoutRedeliveryBackoff(endpoint, pulsarListener);
        this.resolveDeadLetterPolicy(endpoint, pulsarListener);
        this.resolvePulsarConsumerErrorHandler(endpoint, pulsarListener);
    }

    private void resolvePulsarConsumerErrorHandler(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object pulsarConsumerErrorHandler = this.resolveExpression(pulsarListener.pulsarConsumerErrorHandler());
        if (pulsarConsumerErrorHandler instanceof PulsarConsumerErrorHandler) {
            endpoint.setPulsarConsumerErrorHandler((PulsarConsumerErrorHandler)pulsarConsumerErrorHandler);
        } else {
            String pulsarConsumerErrorHandlerBeanName = this.resolveExpressionAsString(pulsarListener.pulsarConsumerErrorHandler(), "pulsarConsumerErrorHandler");
            if (StringUtils.hasText((String)pulsarConsumerErrorHandlerBeanName)) {
                endpoint.setPulsarConsumerErrorHandler((PulsarConsumerErrorHandler)this.beanFactory.getBean(pulsarConsumerErrorHandlerBeanName, PulsarConsumerErrorHandler.class));
            }
        }
    }

    private void resolveNegativeAckRedeliveryBackoff(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object negativeAckRedeliveryBackoff = this.resolveExpression(pulsarListener.negativeAckRedeliveryBackoff());
        if (negativeAckRedeliveryBackoff instanceof RedeliveryBackoff) {
            endpoint.setNegativeAckRedeliveryBackoff((RedeliveryBackoff)negativeAckRedeliveryBackoff);
        } else {
            String negativeAckRedeliveryBackoffBeanName = this.resolveExpressionAsString(pulsarListener.negativeAckRedeliveryBackoff(), "negativeAckRedeliveryBackoff");
            if (StringUtils.hasText((String)negativeAckRedeliveryBackoffBeanName)) {
                endpoint.setNegativeAckRedeliveryBackoff((RedeliveryBackoff)this.beanFactory.getBean(negativeAckRedeliveryBackoffBeanName, RedeliveryBackoff.class));
            }
        }
    }

    private void resolveAckTimeoutRedeliveryBackoff(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object ackTimeoutRedeliveryBackoff = this.resolveExpression(pulsarListener.ackTimeoutRedeliveryBackoff());
        if (ackTimeoutRedeliveryBackoff instanceof RedeliveryBackoff) {
            endpoint.setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)ackTimeoutRedeliveryBackoff);
        } else {
            String ackTimeoutRedeliveryBackoffBeanName = this.resolveExpressionAsString(pulsarListener.ackTimeoutRedeliveryBackoff(), "ackTimeoutRedeliveryBackoff");
            if (StringUtils.hasText((String)ackTimeoutRedeliveryBackoffBeanName)) {
                endpoint.setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)this.beanFactory.getBean(ackTimeoutRedeliveryBackoffBeanName, RedeliveryBackoff.class));
            }
        }
    }

    private void resolveDeadLetterPolicy(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object deadLetterPolicy = this.resolveExpression(pulsarListener.deadLetterPolicy());
        if (deadLetterPolicy instanceof DeadLetterPolicy) {
            endpoint.setDeadLetterPolicy((DeadLetterPolicy)deadLetterPolicy);
        } else {
            String deadLetterPolicyBeanName = this.resolveExpressionAsString(pulsarListener.deadLetterPolicy(), "deadLetterPolicy");
            if (StringUtils.hasText((String)deadLetterPolicyBeanName)) {
                endpoint.setDeadLetterPolicy((DeadLetterPolicy)this.beanFactory.getBean(deadLetterPolicyBeanName, DeadLetterPolicy.class));
            }
        }
    }

    private Integer resolveExpressionAsInteger(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        Integer result = null;
        if (resolved instanceof String) {
            result = Integer.parseInt((String)resolved);
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).intValue();
        } else if (resolved != null) {
            throw new IllegalStateException(THE_LEFT + attribute + "] must resolve to an Number or a String that can be parsed as an Integer. Resolved to [" + resolved.getClass() + RIGHT_FOR_LEFT + value + "]");
        }
        return result;
    }

    private Boolean resolveExpressionAsBoolean(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        Boolean result = null;
        if (resolved instanceof Boolean) {
            result = (Boolean)resolved;
        } else if (resolved instanceof String) {
            result = Boolean.parseBoolean((String)resolved);
        } else if (resolved != null) {
            throw new IllegalStateException(THE_LEFT + attribute + "] must resolve to a Boolean or a String that can be parsed as a Boolean. Resolved to [" + resolved.getClass() + RIGHT_FOR_LEFT + value + "]");
        }
        return result;
    }

    private void resolvePulsarProperties(MethodPulsarListenerEndpoint<?> endpoint, String[] propertyStrings) {
        if (propertyStrings.length > 0) {
            Properties properties = new Properties();
            for (String property : propertyStrings) {
                Object value = this.resolveExpression(property);
                if (value instanceof String) {
                    this.loadProperty(properties, property, value);
                    continue;
                }
                if (value instanceof String[]) {
                    for (String prop : (String[])value) {
                        this.loadProperty(properties, prop, prop);
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    if (values.size() <= 0 || !(values.iterator().next() instanceof String)) continue;
                    for (String prop : (Collection)value) {
                        this.loadProperty(properties, prop, prop);
                    }
                    continue;
                }
                throw new IllegalStateException("'properties' must resolve to a String, a String[] or Collection<String>");
            }
            endpoint.setConsumerProperties(properties);
        }
    }

    private void loadProperty(Properties properties, String property, Object value) {
        try {
            properties.load(new StringReader((String)value));
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, () -> "Failed to load property " + property + ", continuing...");
        }
    }

    private String getEndpointSubscriptionName(PulsarListener pulsarListener) {
        if (StringUtils.hasText((String)pulsarListener.subscriptionName())) {
            return this.resolveExpressionAsString(pulsarListener.subscriptionName(), "subscriptionName");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getEndpointId(PulsarListener pulsarListener) {
        if (StringUtils.hasText((String)pulsarListener.id())) {
            return this.resolveExpressionAsString(pulsarListener.id(), "id");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getTopicPattern(PulsarListener pulsarListener) {
        return this.resolveExpressionAsString(pulsarListener.topicPattern(), "topicPattern");
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        if (resolved != null) {
            throw new IllegalStateException(THE_LEFT + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + RIGHT_FOR_LEFT + value + "]");
        }
        return null;
    }

    private String[] resolveTopics(PulsarListener PulsarListener2) {
        String[] topics = PulsarListener2.topics();
        ArrayList<String> result = new ArrayList<String>();
        if (topics.length > 0) {
            for (String topic1 : topics) {
                Object topic = this.resolveExpression(topic1);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[0]);
    }

    private Object resolveExpression(String value) {
        return this.resolver.evaluate(this.resolve(value), this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private void resolveAsString(Object resolvedValue, List<String> result) {
        if (resolvedValue instanceof String[]) {
            for (String object : (String[])resolvedValue) {
                this.resolveAsString(object, result);
            }
        } else if (resolvedValue instanceof String) {
            result.add((String)resolvedValue);
        } else if (resolvedValue instanceof Iterable) {
            for (Object object : (Iterable)resolvedValue) {
                this.resolveAsString(object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@PulsarListener can't resolve '%s' as a String", resolvedValue));
        }
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@PulsarListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    private Set<PulsarListener> findListenerAnnotations(Method method) {
        PulsarListeners anns;
        HashSet<PulsarListener> listeners = new HashSet<PulsarListener>();
        PulsarListener ann = (PulsarListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PulsarListener.class);
        if (ann != null) {
            ann = this.enhance(method, ann);
            listeners.add(ann);
        }
        if ((anns = (PulsarListeners)AnnotationUtils.findAnnotation((Method)method, PulsarListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).map(anno -> this.enhance(method, (PulsarListener)anno)).toList());
        }
        return listeners;
    }

    private PulsarListener enhance(AnnotatedElement element, PulsarListener ann) {
        if (this.enhancer == null) {
            return ann;
        }
        return (PulsarListener)AnnotationUtils.synthesizeAnnotation((Map)((Map)this.enhancer.apply(AnnotationUtils.getAnnotationAttributes((Annotation)ann), element)), PulsarListener.class, null);
    }

    private void addFormatters(FormatterRegistry registry) {
        this.beanFactory.getBeanProvider(Converter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(GenericConverter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(Formatter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.setBeanFactory((BeanFactory)((ConfigurableApplicationContext)applicationContext).getBeanFactory());
        } else {
            this.setBeanFactory((BeanFactory)applicationContext);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), (Scope)this.listenerScope);
        }
    }

    private class PulsarHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private final DefaultFormattingConversionService defaultFormattingConversionService = new DefaultFormattingConversionService();
        private MessageHandlerMethodFactory handlerMethodFactory;

        private PulsarHandlerMethodFactoryAdapter() {
        }

        public void setHandlerMethodFactory(MessageHandlerMethodFactory pulsarHandlerMethodFactory1) {
            this.handlerMethodFactory = pulsarHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getHandlerMethodFactory() {
            if (this.handlerMethodFactory == null) {
                this.handlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.handlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(PulsarListenerAnnotationBeanPostProcessor.this.beanFactory);
            this.defaultFormattingConversionService.addConverter((Converter)new BytesToStringConverter(PulsarListenerAnnotationBeanPostProcessor.this.charset));
            this.defaultFormattingConversionService.addConverter((GenericConverter)new BytesToNumberConverter());
            defaultFactory.setConversionService((ConversionService)this.defaultFormattingConversionService);
            GenericMessageConverter messageConverter = new GenericMessageConverter((ConversionService)this.defaultFormattingConversionService);
            defaultFactory.setMessageConverter((MessageConverter)messageConverter);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }

    static class ListenerScope
    implements Scope {
        private final Map<String, Object> listeners = new HashMap<String, Object>();

        ListenerScope() {
        }

        public void addListener(String key, Object bean) {
            this.listeners.put(key, bean);
        }

        public void removeListener(String key) {
            this.listeners.remove(key);
        }

        public Object get(String name, ObjectFactory<?> objectFactory) {
            return this.listeners.get(name);
        }

        public Object remove(String name) {
            return null;
        }

        public void registerDestructionCallback(String name, Runnable callback) {
        }

        public Object resolveContextualObject(String key) {
            return this.listeners.get(key);
        }

        public String getConversationId() {
            return null;
        }
    }

    public static interface AnnotationEnhancer
    extends BiFunction<Map<String, Object>, AnnotatedElement, Map<String, Object>> {
    }

    private final class BytesToNumberConverter
    implements ConditionalGenericConverter {
        BytesToNumberConverter() {
        }

        @Nullable
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Long.TYPE));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Integer.TYPE));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Short.TYPE));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Byte.TYPE));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Long.class));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Integer.class));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Short.class));
            pairs.add(new GenericConverter.ConvertiblePair(byte[].class, Byte.class));
            return pairs;
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            byte[] bytes = (byte[])source;
            if (targetType.getType().equals(Long.TYPE) || targetType.getType().equals(Long.class)) {
                Assert.state((bytes.length >= 8 ? 1 : 0) != 0, (String)"At least 8 bytes needed to convert a byte[] to a long");
                return ByteBuffer.wrap(bytes).getLong();
            }
            if (targetType.getType().equals(Integer.TYPE) || targetType.getType().equals(Integer.class)) {
                Assert.state((bytes.length >= 4 ? 1 : 0) != 0, (String)"At least 4 bytes needed to convert a byte[] to an integer");
                return ByteBuffer.wrap(bytes).getInt();
            }
            if (targetType.getType().equals(Short.TYPE) || targetType.getType().equals(Short.class)) {
                Assert.state((bytes.length >= 2 ? 1 : 0) != 0, (String)"At least 2 bytes needed to convert a byte[] to a short");
                return ByteBuffer.wrap(bytes).getShort();
            }
            if (targetType.getType().equals(Byte.TYPE) || targetType.getType().equals(Byte.class)) {
                Assert.state((bytes.length >= 1 ? 1 : 0) != 0, (String)"At least 1 byte needed to convert a byte[] to a byte");
                return ByteBuffer.wrap(bytes).get();
            }
            return null;
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (sourceType.getType().equals(byte[].class)) {
                Class target = targetType.getType();
                return target.equals(Long.TYPE) || target.equals(Integer.TYPE) || target.equals(Short.TYPE) || target.equals(Byte.TYPE) || target.equals(Long.class) || target.equals(Integer.class) || target.equals(Short.class) || target.equals(Byte.class);
            }
            return false;
        }
    }

    private static class BytesToStringConverter
    implements Converter<byte[], String> {
        private final Charset charset;

        BytesToStringConverter(Charset charset) {
            this.charset = charset;
        }

        public String convert(byte[] source) {
            return new String(source, this.charset);
        }
    }
}

