/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.io.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class OsgiResourceUtils {
    public static final String EMPTY_PREFIX = "";
    public static final String PREFIX_DELIMITER = ":";
    public static final String FOLDER_DELIMITER = "/";
    public static final int PREFIX_TYPE_UNKNOWN = -1;
    public static final int PREFIX_TYPE_NOT_SPECIFIED = 0;
    public static final int PREFIX_TYPE_BUNDLE_SPACE = 1;
    public static final int PREFIX_TYPE_CLASS_SPACE = 2;
    public static final int PREFIX_TYPE_BUNDLE_JAR = 4;

    public static String getPrefix(String path) {
        if (path == null) {
            return EMPTY_PREFIX;
        }
        int index = path.indexOf(PREFIX_DELIMITER);
        return index > 0 ? path.substring(0, index + 1) : EMPTY_PREFIX;
    }

    public static int getSearchType(String path) {
        Assert.notNull((Object)path);
        int type = 0;
        String prefix = OsgiResourceUtils.getPrefix(path);
        type = !StringUtils.hasText((String)prefix) ? 0 : (prefix.startsWith("osgibundle:") ? 1 : (prefix.startsWith("osgibundlejar:") ? 4 : (prefix.startsWith("classpath:") ? 2 : (prefix.startsWith("classpath*:") ? 2 : -1))));
        return type;
    }

    public static String stripPrefix(String path) {
        int index = path.indexOf(PREFIX_DELIMITER);
        return index > -1 ? path.substring(index + 1) : path;
    }

    public static Resource[] convertURLArraytoResourceArray(URL[] urls) {
        Resource[] res = new Resource[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            res[i] = new UrlResource(urls[i]);
        }
        return res;
    }

    public static Resource[] convertURLEnumerationToResourceArray(Enumeration enm) {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(5);
        while (enm != null && enm.hasMoreElements()) {
            resources.add((URL)enm.nextElement());
        }
        return OsgiResourceUtils.convertURLArraytoResourceArray(resources.toArray(new URL[resources.size()]));
    }
}

