/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.autoconfigure;

import brave.TracingCustomizer;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import io.micrometer.tracing.Tracer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.modulith.observability.ModuleEventListener;
import org.springframework.modulith.observability.ModuleTracingBeanPostProcessor;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"management.tracing.enabled"}, havingValue="true", matchIfMissing=true)
class ModuleObservabilityAutoConfiguration {
    ModuleObservabilityAutoConfiguration() {
    }

    @Bean
    static ModuleTracingBeanPostProcessor moduleTracingBeanPostProcessor(ApplicationModulesRuntime runtime, ObjectProvider<Tracer> tracer, ConfigurableListableBeanFactory factory) {
        return new ModuleTracingBeanPostProcessor(runtime, () -> (Tracer)tracer.getObject(), factory);
    }

    @Bean
    static ModuleEventListener tracingModuleEventListener(ApplicationModulesRuntime runtime, ObjectProvider<Tracer> tracer) {
        return new ModuleEventListener(runtime, () -> (Tracer)tracer.getObject());
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    SimpleAsyncTaskExecutorCustomizer simpleAsyncTaskExecutorCustomizer() {
        return executor -> executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
    }

    @Bean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    ThreadPoolTaskExecutorCustomizer threadPoolTaskExecutorCustomizer() {
        return executor -> executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
    }

    @ConditionalOnClass(value={TracingCustomizer.class})
    static class ModulithsBraveIntegrationAutoConfiguration {
        ModulithsBraveIntegrationAutoConfiguration() {
        }

        @Bean
        BaggagePropagationCustomizer moduleBaggagePropagationCustomizer() {
            return builder -> builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)"org.springframework.modulith.module")));
        }

        @Bean
        SpanHandler spanHandler() {
            return new SpanHandler(){

                public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
                    String value = span.tag("org.springframework.modulith.module");
                    if (value != null) {
                        span.localServiceName(value);
                        return true;
                    }
                    BaggageField field = BaggageField.getByName((TraceContext)context, (String)"org.springframework.modulith.module");
                    value = field.getValue();
                    if (value != null) {
                        span.localServiceName(value);
                    }
                    return true;
                }
            };
        }
    }
}

