/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.structurizr.Workspace;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.C4PlantUMLExporter;
import com.structurizr.export.plantuml.StructurizrPlantUMLExporter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.Styles;
import com.tngtech.archunit.core.domain.JavaClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleDependency;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.DependencyDepth;
import org.springframework.modulith.core.DependencyType;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.docs.Asciidoctor;
import org.springframework.modulith.docs.ConfigurationProperties;
import org.springframework.modulith.docs.Groupings;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class Documenter {
    private static final Map<DependencyType, String> DEPENDENCY_DESCRIPTIONS = new LinkedHashMap<DependencyType, String>();
    private static final String INVALID_FILE_NAME_PATTERN = "Configured file name pattern does not include a '%s' placeholder for the module name!";
    private static final String DEFAULT_LOCATION = "spring-modulith-docs";
    private static final String DEFAULT_COMPONENTS_FILE = "components.puml";
    private static final String DEFAULT_MODULE_COMPONENTS_FILE = "module-%s.puml";
    private final ApplicationModules modules;
    private final Workspace workspace;
    private final Container container;
    private final ConfigurationProperties properties;
    private final String outputFolder;
    private Map<ApplicationModule, Component> components;

    public Documenter(Class<?> modulithType) {
        this(ApplicationModules.of(modulithType));
    }

    public Documenter(ApplicationModules modules) {
        this(modules, Documenter.getDefaultOutputDirectory());
    }

    public Documenter(ApplicationModules modules, String outputFolder) {
        Assert.notNull((Object)modules, (String)"Modules must not be null!");
        Assert.hasText((String)outputFolder, (String)"Output folder must not be null or empty!");
        this.modules = modules;
        this.outputFolder = outputFolder;
        this.workspace = new Workspace("Modulith", "");
        this.workspace.getViews().getConfiguration().getStyles().addElementStyle("Component").shape(Shape.Component);
        Model model = this.workspace.getModel();
        String systemName = this.getDefaultedSystemName();
        SoftwareSystem system = model.addSoftwareSystem(systemName, "");
        this.container = system.addContainer(systemName, "", "");
        this.properties = new ConfigurationProperties();
    }

    @Deprecated(forRemoval=true)
    public Documenter withOutputFolder(String outputFolder) {
        return new Documenter(this.modules, outputFolder);
    }

    public Documenter writeDocumentation() {
        return this.writeDocumentation(DiagramOptions.defaults(), CanvasOptions.defaults());
    }

    public Documenter writeDocumentation(DiagramOptions options, CanvasOptions canvasOptions) {
        return this.writeModulesAsPlantUml(options).writeIndividualModulesAsPlantUml(options).writeModuleCanvases(canvasOptions).writeAggregatingDocument(options, canvasOptions);
    }

    public Documenter writeAggregatingDocument() {
        return this.writeAggregatingDocument(DiagramOptions.defaults(), CanvasOptions.defaults());
    }

    public Documenter writeAggregatingDocument(DiagramOptions options, CanvasOptions canvasOptions) {
        String moduleDocs;
        String allDocs;
        Assert.notNull((Object)options, (String)"DiagramOptions must not be null!");
        Assert.notNull((Object)canvasOptions, (String)"CanvasOptions must not be null!");
        Asciidoctor asciidoctor = Asciidoctor.withJavadocBase(this.modules, canvasOptions.getApiBase());
        OutputFolder outputFolder = new OutputFolder(this.outputFolder);
        String componentsFilename = options.getTargetFileName().orElse(DEFAULT_COMPONENTS_FILE);
        StringBuilder componentsDoc = new StringBuilder();
        if (outputFolder.contains(componentsFilename)) {
            componentsDoc.append(asciidoctor.renderHeadline(2, this.getDefaultedSystemName())).append(asciidoctor.renderPlantUmlInclude(componentsFilename)).append(System.lineSeparator());
        }
        if (!(allDocs = componentsDoc.append(moduleDocs = this.modules.stream().map(it -> {
            String fileNamePattern = options.getTargetFileName().orElse(DEFAULT_MODULE_COMPONENTS_FILE);
            String filename = fileNamePattern.formatted(it.getName());
            String canvasFilename = canvasOptions.getTargetFileName(it.getName());
            StringBuilder content = new StringBuilder();
            content.append(outputFolder.contains(filename) ? asciidoctor.renderPlantUmlInclude(filename) : "").append(outputFolder.contains(canvasFilename) ? asciidoctor.renderGeneralInclude(canvasFilename) : "");
            if (!content.isEmpty()) {
                content.insert(0, asciidoctor.renderHeadline(2, it.getDisplayName())).append(System.lineSeparator());
            }
            return content.toString();
        }).collect(Collectors.joining())).toString()).isBlank()) {
            Path file = this.recreateFile("all-docs.adoc");
            try (FileWriter writer = new FileWriter(file.toFile());){
                writer.write(allDocs);
            }
            catch (IOException o_O) {
                throw new RuntimeException(o_O);
            }
        }
        return this;
    }

    public Documenter writeModulesAsPlantUml() {
        return this.writeModulesAsPlantUml(DiagramOptions.defaults());
    }

    public Documenter writeModulesAsPlantUml(DiagramOptions options) {
        Assert.notNull((Object)options, (String)"Options must not be null!");
        Path file = this.recreateFile(options.getTargetFileName().orElse(DEFAULT_COMPONENTS_FILE));
        try (FileWriter writer = new FileWriter(file.toFile());){
            writer.write(this.createPlantUml(options));
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
        return this;
    }

    public Documenter writeIndividualModulesAsPlantUml() {
        return this.writeIndividualModulesAsPlantUml(DiagramOptions.defaults());
    }

    public Documenter writeIndividualModulesAsPlantUml(DiagramOptions options) {
        Assert.notNull((Object)options, (String)"DiagramOptions must not be null!");
        this.modules.forEach(it -> this.writeModuleAsPlantUml((ApplicationModule)it, options));
        return this;
    }

    public Documenter writeModuleAsPlantUml(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        return this.writeModuleAsPlantUml(module, DiagramOptions.defaults());
    }

    public Documenter writeModuleAsPlantUml(ApplicationModule module, DiagramOptions options) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        ComponentView view = this.createComponentView(options, module);
        view.setTitle(options.defaultDisplayName.apply(module));
        this.addComponentsToView(module, view, options);
        String fileNamePattern = options.getTargetFileName().orElse(DEFAULT_MODULE_COMPONENTS_FILE);
        return this.writeViewAsPlantUml(view, fileNamePattern.formatted(module.getName()), options);
    }

    public Documenter writeModuleCanvases() {
        return this.writeModuleCanvases(CanvasOptions.defaults());
    }

    public Documenter writeModuleCanvases(CanvasOptions options) {
        Assert.notNull((Object)options, (String)"CanvasOptions must not be null!");
        this.modules.forEach(module -> {
            String filename = options.getTargetFileName(module.getName());
            Path file = this.recreateFile(filename);
            try (FileWriter writer = new FileWriter(file.toFile());){
                writer.write(this.toModuleCanvas((ApplicationModule)module, options));
            }
            catch (IOException o_O) {
                throw new RuntimeException(o_O);
            }
        });
        return this;
    }

    String toModuleCanvas(ApplicationModule module) {
        return this.toModuleCanvas(module, CanvasOptions.defaults());
    }

    String toModuleCanvas(ApplicationModule module, String apiBase) {
        return this.toModuleCanvas(module, CanvasOptions.defaults().withApiBase(apiBase));
    }

    String toModuleCanvas(ApplicationModule module, CanvasOptions options) {
        Asciidoctor asciidoctor = Asciidoctor.withJavadocBase(this.modules, options.getApiBase());
        Predicate<JavaClass> filter = options.hideInternalFilter(module);
        List<JavaClass> aggregates = module.getAggregateRoots().stream().filter(filter).toList();
        List<JavaClass> valueTypes = module.getValueTypes().stream().filter(filter).toList();
        Function mapper = asciidoctor::typesToBulletPoints;
        return Asciidoctor.startTable("%autowidth.stretch, cols=\"h,a\"") + Documenter.addTableRow("Base package", asciidoctor.toInlineCode(module.getBasePackage().getName()), options) + Documenter.addTableRow("Spring components", asciidoctor.renderSpringBeans(module, options), options) + Documenter.addTableRow("Bean references", asciidoctor.renderBeanReferences(module), options) + Documenter.addTableRow(aggregates, "Aggregate roots", mapper, options) + Documenter.addTableRow(valueTypes, "Value types", mapper, options) + Documenter.addTableRow("Published events", asciidoctor.renderEvents(module), options) + Documenter.addTableRow(module.getEventsListenedTo(this.modules), "Events listened to", mapper, options) + Documenter.addTableRow("Properties", asciidoctor.renderConfigurationProperties(this.properties.getModuleProperties(module)), options) + Asciidoctor.startOrEndTable();
    }

    ApplicationModules getModules() {
        return this.modules;
    }

    String toPlantUml() {
        return this.createPlantUml(DiagramOptions.defaults());
    }

    private void addDependencies(ApplicationModule module, Component component, DiagramOptions options) {
        DEPENDENCY_DESCRIPTIONS.entrySet().stream().forEach(entry -> module.getDependencies(this.modules, new DependencyType[]{(DependencyType)entry.getKey()}).stream().map(ApplicationModuleDependency::getTargetModule).map(it -> this.getComponents(options).get(it)).map(it -> component.uses(it, (String)entry.getValue())).filter(it -> it != null).forEach(it -> it.addTags(new String[]{((DependencyType)entry.getKey()).toString()})));
        module.getBootstrapDependencies(this.modules).map(it -> component.uses(this.getComponents(options).get(it), "uses")).filter(it -> it != null).forEach(it -> it.addTags(new String[]{DependencyType.USES_COMPONENT.toString()}));
    }

    private Map<ApplicationModule, Component> getComponents(DiagramOptions options) {
        if (this.components == null) {
            this.components = this.modules.stream().collect(Collectors.toMap(Function.identity(), it -> this.container.addComponent(options.defaultDisplayName.apply((ApplicationModule)it), "", "Module")));
            this.components.forEach((key, value) -> this.addDependencies((ApplicationModule)key, (Component)value, options));
        }
        return this.components;
    }

    private void addComponentsToView(ApplicationModule module, ComponentView view, DiagramOptions options) {
        Supplier<Stream> bootstrapDependencies = () -> module.getBootstrapDependencies(this.modules, options.dependencyDepth);
        Supplier<Stream> otherDependencies = () -> options.getDependencyTypes().flatMap(it -> module.getDependencies(this.modules, new DependencyType[]{it}).stream().map(ApplicationModuleDependency::getTargetModule));
        Supplier<Stream<ApplicationModule>> dependencies = () -> Stream.concat((Stream)bootstrapDependencies.get(), (Stream)otherDependencies.get());
        this.addComponentsToView(dependencies, view, options, it -> it.add(this.getComponents(options).get(module)));
    }

    private void addComponentsToView(Supplier<Stream<ApplicationModule>> modules, ComponentView view, DiagramOptions options, Consumer<ComponentView> afterCleanup) {
        Styles styles = view.getViewSet().getConfiguration().getStyles();
        Map<ApplicationModule, Component> components = this.getComponents(options);
        modules.get().distinct().filter(options.exclusions.negate()).map(it -> Documenter.applyBackgroundColor(it, components, options, styles)).filter(options.componentFilter).forEach(arg_0 -> ((ComponentView)view).add(arg_0));
        DependencyType.allBut(options.getDependencyTypes()).map(Object::toString).forEach(it -> view.removeRelationshipsWithTag(it));
        afterCleanup.accept(view);
        modules.get().filter(options.targetOnly).forEach(module -> {
            Component component = (Component)components.get(module);
            view.getRelationships().stream().map(RelationshipView::getRelationship).filter(it -> it.getSource().equals(component)).forEach(it -> view.remove(it));
        });
        if (options.hideElementsWithoutRelationships()) {
            view.removeElementsWithNoRelationships();
        }
        afterCleanup.accept(view);
        view.getRelationships().stream().map(RelationshipView::getRelationship).collect(Collectors.groupingBy(Connection::of)).values().stream().forEach(it -> this.potentiallyRemoveDefaultRelationship((ModelView)view, (Collection<Relationship>)it));
    }

    private void potentiallyRemoveDefaultRelationship(ModelView view, Collection<Relationship> relationships) {
        if (relationships.size() <= 1) {
            return;
        }
        relationships.stream().filter(it -> it.getTagsAsSet().contains(DependencyType.DEFAULT.toString())).findFirst().ifPresent(arg_0 -> ((ModelView)view).remove(arg_0));
    }

    private Documenter writeViewAsPlantUml(ComponentView view, String filename, DiagramOptions options) {
        Documenter documenter;
        Path file = this.recreateFile(filename);
        FileWriter writer = new FileWriter(file.toFile());
        try {
            writer.write(this.render(view, options));
            documenter = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException o_O) {
                throw new RuntimeException(o_O);
            }
        }
        ((Writer)writer).close();
        return documenter;
    }

    private String render(ComponentView view, DiagramOptions options) {
        switch (options.style) {
            case C4: {
                C4PlantUMLExporter c4PlantUmlExporter = new C4PlantUMLExporter();
                Diagram diagram = c4PlantUmlExporter.export(view);
                return diagram.getDefinition();
            }
        }
        CustomizedPlantUmlExporter plantUmlExporter = new CustomizedPlantUmlExporter();
        plantUmlExporter.addSkinParam("componentStyle", "uml1");
        return plantUmlExporter.export(view).getDefinition();
    }

    private String createPlantUml(DiagramOptions options) {
        ComponentView componentView = this.createComponentView(options);
        componentView.setTitle(this.getDefaultedSystemName());
        this.addComponentsToView(() -> this.modules.stream(), componentView, options, it -> {});
        return this.render(componentView, options);
    }

    private ComponentView createComponentView(DiagramOptions options) {
        return this.createComponentView(options, null);
    }

    private ComponentView createComponentView(DiagramOptions options, @Nullable ApplicationModule module) {
        String prefix = module == null ? "modules-" : module.getName();
        return this.workspace.getViews().createComponentView(this.container, prefix + options.toString(), "");
    }

    private Path recreateFile(String name) {
        try {
            Files.createDirectories(Paths.get(this.outputFolder, new String[0]), new FileAttribute[0]);
            Path filePath = Paths.get(this.outputFolder, name);
            Files.deleteIfExists(filePath);
            return Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private static Component applyBackgroundColor(ApplicationModule module, Map<ApplicationModule, Component> components, DiagramOptions options, Styles styles) {
        Component component = components.get(module);
        Function<ApplicationModule, Optional<String>> selector = options.colorSelector;
        selector.apply(module).ifPresent(color -> {
            String tag = module.getName() + "-" + color;
            component.addTags(new String[]{tag});
            styles.getElements().stream().filter(it -> it.getTag().equals(tag)).findFirst().orElseGet(() -> styles.addElementStyle(tag)).background(color);
        });
        return component;
    }

    private static String addTableRow(String title, String content, CanvasOptions options) {
        return options.hideEmptyLines && (content.isBlank() || content.equalsIgnoreCase("none")) ? "" : Asciidoctor.writeTableRow(title, content);
    }

    private static <T> String addTableRow(List<T> types, String header, Function<List<T>, String> mapper, CanvasOptions options) {
        return options.hideEmptyLines && types.isEmpty() ? "" : Asciidoctor.writeTableRow(header, mapper.apply(types));
    }

    private static String getDefaultOutputDirectory() {
        return (new File("pom.xml").exists() ? "target" : "build").concat("/").concat(DEFAULT_LOCATION);
    }

    private String getDefaultedSystemName() {
        return this.modules.getSystemName().orElse("Modules");
    }

    static {
        DEPENDENCY_DESCRIPTIONS.put(DependencyType.EVENT_LISTENER, "listens to");
        DEPENDENCY_DESCRIPTIONS.put(DependencyType.DEFAULT, "depends on");
    }

    public static class DiagramOptions {
        private static final Set<DependencyType> ALL_TYPES = Arrays.stream(DependencyType.values()).collect(Collectors.toSet());
        private final Set<DependencyType> dependencyTypes;
        private final DependencyDepth dependencyDepth;
        private final Predicate<ApplicationModule> exclusions;
        private final Predicate<Component> componentFilter;
        private final Predicate<ApplicationModule> targetOnly;
        @Nullable
        private final String targetFileName;
        private final Function<ApplicationModule, Optional<String>> colorSelector;
        private final Function<ApplicationModule, String> defaultDisplayName;
        private final DiagramStyle style;
        private final ElementsWithoutRelationships elementsWithoutRelationships;

        DiagramOptions(Set<DependencyType> dependencyTypes, DependencyDepth dependencyDepth, Predicate<ApplicationModule> exclusions, Predicate<Component> componentFilter, Predicate<ApplicationModule> targetOnly, @Nullable String targetFileName, Function<ApplicationModule, Optional<String>> colorSelector, Function<ApplicationModule, String> defaultDisplayName, DiagramStyle style, ElementsWithoutRelationships elementsWithoutRelationships) {
            Assert.notNull(dependencyTypes, (String)"Dependency types must not be null!");
            Assert.notNull((Object)dependencyDepth, (String)"Dependency depth must not be null!");
            Assert.notNull(exclusions, (String)"Exclusions must not be null!");
            Assert.notNull(componentFilter, (String)"Component filter must not be null!");
            Assert.notNull(targetOnly, (String)"Target only must not be null!");
            Assert.notNull(colorSelector, (String)"Color selector must not be null!");
            Assert.notNull(defaultDisplayName, (String)"Default display name must not be null!");
            Assert.notNull((Object)((Object)style), (String)"DiagramStyle must not be null!");
            Assert.notNull((Object)((Object)elementsWithoutRelationships), (String)"ElementsWithoutRelationships must not be null!");
            this.dependencyTypes = dependencyTypes;
            this.dependencyDepth = dependencyDepth;
            this.exclusions = exclusions;
            this.componentFilter = componentFilter;
            this.targetOnly = targetOnly;
            this.targetFileName = targetFileName;
            this.colorSelector = colorSelector;
            this.defaultDisplayName = defaultDisplayName;
            this.style = style;
            this.elementsWithoutRelationships = elementsWithoutRelationships;
        }

        public DiagramOptions withDependencyDepth(DependencyDepth dependencyDepth) {
            return new DiagramOptions(this.dependencyTypes, dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withExclusions(Predicate<ApplicationModule> exclusions) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withComponentFilter(Predicate<Component> componentFilter) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withTargetOnly(Predicate<ApplicationModule> targetOnly) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withTargetFileName(String targetFileName) {
            Assert.isTrue((boolean)targetFileName.contains("%s"), () -> Documenter.INVALID_FILE_NAME_PATTERN.formatted(targetFileName));
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withColorSelector(Function<ApplicationModule, Optional<String>> colorSelector) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withDefaultDisplayName(Function<ApplicationModule, String> defaultDisplayName) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withStyle(DiagramStyle style) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, style, this.elementsWithoutRelationships);
        }

        public DiagramOptions withElementsWithoutRelationships(ElementsWithoutRelationships elementsWithoutRelationships) {
            return new DiagramOptions(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, elementsWithoutRelationships);
        }

        public static DiagramOptions defaults() {
            return new DiagramOptions(ALL_TYPES, DependencyDepth.IMMEDIATE, it -> false, it -> true, it -> false, null, __ -> Optional.empty(), it -> it.getDisplayName(), DiagramStyle.C4, ElementsWithoutRelationships.HIDDEN);
        }

        public DiagramOptions withDependencyTypes(DependencyType ... types) {
            Assert.notNull((Object)types, (String)"Dependency types must not be null!");
            Set<DependencyType> dependencyTypes = Arrays.stream(types).collect(Collectors.toSet());
            return new DiagramOptions(dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style, this.elementsWithoutRelationships);
        }

        private Optional<String> getTargetFileName() {
            return Optional.ofNullable(this.targetFileName);
        }

        private Stream<DependencyType> getDependencyTypes() {
            return this.dependencyTypes.stream();
        }

        private boolean hideElementsWithoutRelationships() {
            return this.elementsWithoutRelationships.equals((Object)ElementsWithoutRelationships.HIDDEN);
        }

        public static enum DiagramStyle {
            UML,
            C4;

        }

        public static enum ElementsWithoutRelationships {
            HIDDEN,
            VISIBLE;

        }
    }

    public static class CanvasOptions {
        static final Grouping FALLBACK_GROUP = new Grouping("Others", __ -> true, null);
        private final List<Grouping> groupers;
        @Nullable
        private final String apiBase;
        @Nullable
        private final String targetFileName;
        private final boolean hideInternals;
        private final boolean hideEmptyLines;

        CanvasOptions(List<Grouping> groupers, @Nullable String apiBase, @Nullable String targetFileName, boolean hideInternals, boolean hideEmptyLines) {
            this.groupers = groupers;
            this.apiBase = apiBase;
            this.targetFileName = targetFileName;
            this.hideInternals = hideInternals;
            this.hideEmptyLines = hideEmptyLines;
        }

        public static CanvasOptions defaults() {
            return CanvasOptions.withoutDefaultGroupings().groupingBy(Groupings.JMoleculesGroupings.getGroupings()).groupingBy(Groupings.SpringGroupings.getGroupings());
        }

        public static CanvasOptions withoutDefaultGroupings() {
            return new CanvasOptions(new ArrayList<Grouping>(), null, null, true, true);
        }

        public CanvasOptions groupingBy(Grouping ... groupings) {
            ArrayList<Grouping> result = new ArrayList<Grouping>(this.groupers);
            result.addAll(List.of(groupings));
            return new CanvasOptions(result, this.apiBase, this.targetFileName, this.hideInternals, this.hideEmptyLines);
        }

        public CanvasOptions groupingBy(String name, Predicate<SpringBean> filter) {
            return this.groupingBy(Grouping.of(name, filter, null));
        }

        public CanvasOptions groupingBy(String name, Predicate<SpringBean> filter, String description) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            Assert.notNull(filter, (String)"Filter must not be null!");
            Assert.hasText((String)description, (String)"Description must not be null!");
            return this.groupingBy(Grouping.of(name, filter, description));
        }

        public CanvasOptions revealInternals() {
            return new CanvasOptions(this.groupers, this.apiBase, this.targetFileName, false, this.hideEmptyLines);
        }

        public CanvasOptions revealEmptyLines() {
            return new CanvasOptions(this.groupers, this.apiBase, this.targetFileName, this.hideInternals, false);
        }

        public CanvasOptions withApiBase(String apiBase) {
            Assert.hasText((String)apiBase, (String)"API base must not be null or empty!");
            return new CanvasOptions(this.groupers, apiBase, this.targetFileName, this.hideInternals, this.hideEmptyLines);
        }

        public CanvasOptions withTargetFileName(String targetFileName) {
            return new CanvasOptions(this.groupers, this.apiBase, targetFileName, this.hideInternals, this.hideEmptyLines);
        }

        String getApiBase() {
            return this.apiBase;
        }

        Groupings groupBeans(ApplicationModule module) {
            ArrayList<Grouping> sources = new ArrayList<Grouping>(this.groupers);
            sources.add(FALLBACK_GROUP);
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            ArrayList alreadyMapped = new ArrayList();
            sources.forEach(it -> {
                List<SpringBean> matchingBeans = this.getMatchingBeans(module, (Grouping)it, alreadyMapped);
                result.addAll(it, matchingBeans);
                alreadyMapped.addAll(matchingBeans);
            });
            new HashSet(result.keySet()).forEach(key -> {
                if (result.get(key).isEmpty()) {
                    result.remove(key);
                }
            });
            return new Groupings((MultiValueMap<Grouping, SpringBean>)result);
        }

        Predicate<JavaClass> hideInternalFilter(ApplicationModule module) {
            return this.hideInternals ? arg_0 -> ((ApplicationModule)module).isExposed(arg_0) : __ -> true;
        }

        private String getTargetFileName(String moduleName) {
            return (this.targetFileName == null ? "module-%s.adoc" : this.targetFileName).formatted(moduleName);
        }

        private List<SpringBean> getMatchingBeans(ApplicationModule module, Grouping filter, List<SpringBean> alreadyMapped) {
            return module.getSpringBeans().stream().filter(it -> !this.hideInternals || it.isApiBean()).filter(it -> !alreadyMapped.contains(it)).filter(filter::matches).toList();
        }

        public static class Grouping {
            private final String name;
            private final Predicate<SpringBean> predicate;
            @Nullable
            private final String description;

            private Grouping(String name, Predicate<SpringBean> predicate, @Nullable String description) {
                Assert.hasText((String)name, (String)"Name must not be null or empty!");
                Assert.notNull(predicate, (String)"Predicate must not be null!");
                Assert.isTrue((description == null || !description.isBlank() ? 1 : 0) != 0, (String)"Description must not be empty or null!");
                this.name = name;
                this.predicate = predicate;
                this.description = description;
            }

            @Deprecated
            public static Grouping of(String name) {
                return new Grouping(name, __ -> false, null);
            }

            public static Grouping of(String name, Predicate<SpringBean> predicate) {
                return new Grouping(name, predicate, null);
            }

            public static Grouping of(String name, Predicate<SpringBean> predicate, String description) {
                return new Grouping(name, predicate, description);
            }

            public static Predicate<SpringBean> nameMatching(String pattern) {
                Assert.hasText((String)pattern, (String)"Pattern must not be null or empty!");
                return bean -> bean.getFullyQualifiedTypeName().matches(pattern);
            }

            public static Predicate<SpringBean> implementing(Class<?> type) {
                Assert.notNull(type, (String)"Type must not be null!");
                return bean -> bean.getType().isAssignableTo(type);
            }

            public static Predicate<SpringBean> subtypeOf(Class<?> type) {
                Assert.notNull(type, (String)"Type must not be null!");
                return Grouping.implementing(type).and(bean -> !bean.getType().isEquivalentTo(type));
            }

            public static Predicate<SpringBean> isAnnotatedWith(Class<? extends Annotation> type) {
                return bean -> bean.getType().isAnnotatedWith(type);
            }

            public String getName() {
                return this.name;
            }

            @Nullable
            public String getDescription() {
                return this.description;
            }

            public boolean matches(SpringBean candidate) {
                Assert.notNull((Object)candidate, (String)"Candidate Spring bean must not be null!");
                return this.predicate.test(candidate);
            }
        }

        static class Groupings {
            private final MultiValueMap<Grouping, SpringBean> groupings;

            Groupings(MultiValueMap<Grouping, SpringBean> groupings) {
                Assert.notNull(groupings, (String)"Groupings must not be null!");
                this.groupings = groupings;
            }

            Set<Grouping> keySet() {
                return this.groupings.keySet();
            }

            List<SpringBean> byGrouping(Grouping grouping) {
                return this.byFilter(grouping::equals);
            }

            List<SpringBean> byGroupName(String name) {
                return this.byFilter(it -> it.name.equals(name));
            }

            void forEach(BiConsumer<Grouping, List<SpringBean>> consumer) {
                this.groupings.forEach(consumer);
            }

            private List<SpringBean> byFilter(Predicate<Grouping> filter) {
                return this.groupings.entrySet().stream().filter(it -> filter.test((Grouping)it.getKey())).findFirst().map(Map.Entry::getValue).orElseGet(Collections::emptyList);
            }

            boolean hasOnlyFallbackGroup() {
                return this.groupings.size() == 1 && this.groupings.get((Object)FALLBACK_GROUP) != null;
            }
        }
    }

    private static class OutputFolder {
        private final String path;

        OutputFolder(String path) {
            this.path = path;
        }

        boolean contains(String filename) {
            return Files.exists(Paths.get(this.path, filename), new LinkOption[0]);
        }
    }

    private static class CustomizedPlantUmlExporter
    extends StructurizrPlantUMLExporter {
        private CustomizedPlantUmlExporter() {
        }

        protected boolean includeTitle(ModelView view) {
            return false;
        }

        protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        }

        protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        }
    }

    private record Connection(Element source, Element target) {
        public static Connection of(Relationship relationship) {
            return new Connection(relationship.getSource(), relationship.getDestination());
        }
    }
}

