/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test.unboundid;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;

public final class EmbeddedLdapServer {
    private InMemoryDirectoryServer directoryServer;

    private EmbeddedLdapServer(InMemoryDirectoryServer directoryServer) {
        this.directoryServer = directoryServer;
    }

    public static EmbeddedLdapServer newEmbeddedServer(String defaultPartitionName, String defaultPartitionSuffix, int port) throws Exception {
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{defaultPartitionSuffix});
        config.addAdditionalBindCredentials("uid=admin,ou=system", "secret");
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"LDAP", (int)port)});
        config.setEnforceSingleStructuralObjectClass(false);
        config.setEnforceAttributeSyntaxCompliance(true);
        Entry entry = new Entry(new DN(defaultPartitionSuffix));
        entry.addAttribute("objectClass", new String[]{"top", "domain", "extensibleObject"});
        entry.addAttribute("dc", defaultPartitionName);
        InMemoryDirectoryServer directoryServer = new InMemoryDirectoryServer(config);
        directoryServer.add(entry);
        directoryServer.startListening();
        return new EmbeddedLdapServer(directoryServer);
    }

    public void shutdown() throws Exception {
        this.directoryServer.shutDown(true);
    }
}

