/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonMapperUtils;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.kafka.support.serializer.JacksonJsonDeserializer;
import org.springframework.kafka.support.serializer.JacksonJsonSerializer;
import org.springframework.util.Assert;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonSerde<T>
implements Serde<T> {
    private final JacksonJsonSerializer<T> jsonSerializer;
    private final JacksonJsonDeserializer<T> jsonDeserializer;

    public JacksonJsonSerde() {
        this((JavaType)null, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerde(@Nullable Class<? super T> targetType) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerde(@Nullable TypeReference<? super T> targetType) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerde(@Nullable JavaType targetType) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerde(JsonMapper jsonMapper) {
        this((JavaType)null, jsonMapper);
    }

    public JacksonJsonSerde(@Nullable TypeReference<? super T> targetType, JsonMapper jsonMapper) {
        this(targetType == null ? null : jsonMapper.constructType(targetType.getType()), jsonMapper);
    }

    public JacksonJsonSerde(@Nullable Class<? super T> targetType, JsonMapper jsonMapper) {
        this(targetType == null ? null : jsonMapper.constructType(targetType), jsonMapper);
    }

    public JacksonJsonSerde(@Nullable JavaType targetTypeArg, @Nullable JsonMapper jsonMapperArg) {
        Class resolvedGeneric;
        JsonMapper jsonMapper;
        JsonMapper jsonMapper2 = jsonMapper = jsonMapperArg == null ? JacksonMapperUtils.enhancedJsonMapper() : jsonMapperArg;
        JavaType actualJavaType = targetTypeArg != null ? targetTypeArg : ((resolvedGeneric = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0})) != null ? jsonMapper.constructType((Type)resolvedGeneric) : null);
        this.jsonSerializer = new JacksonJsonSerializer(actualJavaType, jsonMapper);
        this.jsonDeserializer = new JacksonJsonDeserializer(actualJavaType, jsonMapper);
    }

    public JacksonJsonSerde(JacksonJsonSerializer<T> jsonSerializer, JacksonJsonDeserializer<T> jsonDeserializer) {
        Assert.notNull(jsonSerializer, (String)"'jsonSerializer' must not be null.");
        Assert.notNull(jsonDeserializer, (String)"'jsonDeserializer' must not be null.");
        this.jsonSerializer = jsonSerializer;
        this.jsonDeserializer = jsonDeserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.jsonSerializer.configure(configs, isKey);
        this.jsonDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.jsonSerializer.close();
        this.jsonDeserializer.close();
    }

    public JacksonJsonSerializer<T> serializer() {
        return this.jsonSerializer;
    }

    public JacksonJsonDeserializer<T> deserializer() {
        return this.jsonDeserializer;
    }

    public <X> JacksonJsonSerde<X> copyWithType(Class<? super X> newTargetType) {
        return new JacksonJsonSerde<X>(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public <X> JacksonJsonSerde<X> copyWithType(TypeReference<? super X> newTargetType) {
        return new JacksonJsonSerde<X>(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public <X> JacksonJsonSerde<X> copyWithType(JavaType newTargetType) {
        return new JacksonJsonSerde(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public JacksonJsonSerde<T> forKeys() {
        this.jsonSerializer.forKeys();
        this.jsonDeserializer.forKeys();
        return this;
    }

    public JacksonJsonSerde<T> noTypeInfo() {
        this.jsonSerializer.noTypeInfo();
        return this;
    }

    public JacksonJsonSerde<T> dontRemoveTypeHeaders() {
        this.jsonDeserializer.dontRemoveTypeHeaders();
        return this;
    }

    public JacksonJsonSerde<T> ignoreTypeHeaders() {
        this.jsonDeserializer.ignoreTypeHeaders();
        return this;
    }

    public JacksonJsonSerde<T> typeMapper(JacksonJavaTypeMapper mapper) {
        this.jsonSerializer.setTypeMapper(mapper);
        this.jsonDeserializer.setTypeMapper(mapper);
        return this;
    }
}

