/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.event.ConsumerStoppedEvent;
import org.springframework.kafka.listener.ContainerProperties;

public interface MessageListenerContainer
extends SmartLifecycle,
DisposableBean {
    public void setupMessageListener(Object var1);

    public Map<String, Map<MetricName, ? extends Metric>> metrics();

    default public ContainerProperties getContainerProperties() {
        throw new UnsupportedOperationException("This container doesn't support retrieving its properties");
    }

    default public @Nullable Collection<TopicPartition> getAssignedPartitions() {
        throw new UnsupportedOperationException("This container doesn't support retrieving its assigned partitions");
    }

    default public @Nullable Map<String, Collection<TopicPartition>> getAssignmentsByClientId() {
        throw new UnsupportedOperationException("This container doesn't support retrieving its assigned partitions");
    }

    default public void enforceRebalance() {
        throw new UnsupportedOperationException("This container doesn't support enforced rebalance");
    }

    default public void pause() {
        throw new UnsupportedOperationException("This container doesn't support pause");
    }

    default public void resume() {
        throw new UnsupportedOperationException("This container doesn't support resume");
    }

    default public void pausePartition(TopicPartition topicPartition) {
        throw new UnsupportedOperationException("This container doesn't support pausing a partition");
    }

    default public void resumePartition(TopicPartition topicPartition) {
        throw new UnsupportedOperationException("This container doesn't support resuming a partition");
    }

    default public boolean isPartitionPauseRequested(TopicPartition topicPartition) {
        throw new UnsupportedOperationException("This container doesn't support pausing a partition");
    }

    default public boolean isPartitionPaused(TopicPartition topicPartition) {
        throw new UnsupportedOperationException("This container doesn't support checking if a partition is paused");
    }

    default public boolean isPauseRequested() {
        throw new UnsupportedOperationException("This container doesn't support pause/resume");
    }

    default public boolean isContainerPaused() {
        throw new UnsupportedOperationException("This container doesn't support pause/resume");
    }

    default public void setAutoStartup(boolean autoStartup) {
    }

    default public @Nullable String getGroupId() {
        throw new UnsupportedOperationException("This container does not support retrieving the group id");
    }

    default public String getListenerId() {
        throw new UnsupportedOperationException("This container does not support retrieving the listener id");
    }

    default public @Nullable String getMainListenerId() {
        throw new UnsupportedOperationException("This container does not support retrieving the main listener id");
    }

    default public @Nullable byte[] getListenerInfo() {
        throw new UnsupportedOperationException("This container does not support retrieving the listener info");
    }

    default public boolean isChildRunning() {
        return this.isRunning();
    }

    default public boolean isInExpectedState() {
        return true;
    }

    default public void stopAbnormally(Runnable callback) {
        this.stop(callback);
    }

    default public MessageListenerContainer getContainerFor(String topic, int partition) {
        return this;
    }

    default public void childStopped(MessageListenerContainer child, ConsumerStoppedEvent.Reason reason) {
    }

    default public void childStarted(MessageListenerContainer child) {
    }

    default public void destroy() {
        this.stop();
    }
}

