/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.ConsumerSeekAware;

public abstract class AbstractConsumerSeekAware
implements ConsumerSeekAware {
    private final Map<Thread, ConsumerSeekAware.ConsumerSeekCallback> callbackForThread = new ConcurrentHashMap<Thread, ConsumerSeekAware.ConsumerSeekCallback>();
    private final Map<TopicPartition, List<ConsumerSeekAware.ConsumerSeekCallback>> topicToCallbacks = new ConcurrentHashMap<TopicPartition, List<ConsumerSeekAware.ConsumerSeekCallback>>();
    private final Map<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>> callbackToTopics = new ConcurrentHashMap<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>>();

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        this.callbackForThread.put(Thread.currentThread(), callback);
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        ConsumerSeekAware.ConsumerSeekCallback threadCallback = this.callbackForThread.get(Thread.currentThread());
        if (threadCallback != null) {
            assignments.keySet().forEach(tp -> {
                this.topicToCallbacks.computeIfAbsent((TopicPartition)tp, key -> new ArrayList()).add(threadCallback);
                this.callbackToTopics.computeIfAbsent(threadCallback, key -> new LinkedList()).add(tp);
            });
        }
    }

    @Override
    public void onPartitionsRevoked(@Nullable Collection<TopicPartition> partitions) {
        if (partitions != null) {
            partitions.forEach(tp -> {
                List<ConsumerSeekAware.ConsumerSeekCallback> removedCallbacks = this.topicToCallbacks.remove(tp);
                if (removedCallbacks != null && !removedCallbacks.isEmpty()) {
                    removedCallbacks.forEach(cb -> {
                        List<TopicPartition> topics = this.callbackToTopics.get(cb);
                        if (topics != null) {
                            topics.remove(tp);
                            if (topics.isEmpty()) {
                                this.callbackToTopics.remove(cb);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public void unregisterSeekCallback() {
        this.callbackForThread.remove(Thread.currentThread());
    }

    protected @Nullable List<ConsumerSeekAware.ConsumerSeekCallback> getSeekCallbacksFor(TopicPartition topicPartition) {
        return this.topicToCallbacks.get(topicPartition);
    }

    protected Map<TopicPartition, List<ConsumerSeekAware.ConsumerSeekCallback>> getTopicsAndCallbacks() {
        return Collections.unmodifiableMap(this.topicToCallbacks);
    }

    protected Map<ConsumerSeekAware.ConsumerSeekCallback, List<TopicPartition>> getCallbacksAndTopics() {
        return Collections.unmodifiableMap(this.callbackToTopics);
    }

    public void seekToBeginning() {
        this.getCallbacksAndTopics().forEach(ConsumerSeekAware.ConsumerSeekCallback::seekToBeginning);
    }

    public void seekToEnd() {
        this.getCallbacksAndTopics().forEach(ConsumerSeekAware.ConsumerSeekCallback::seekToEnd);
    }

    public void seekToTimestamp(long time) {
        this.getCallbacksAndTopics().forEach((cb, topics) -> cb.seekToTimestamp((Collection<TopicPartition>)topics, time));
    }
}

