/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.event.KafkaEvent;

public class ListenerContainerPartitionIdleEvent
extends KafkaEvent {
    private static final long serialVersionUID = 1L;
    private final long idleTime;
    private final String listenerId;
    private final TopicPartition topicPartition;
    private final boolean paused;
    private final transient Consumer<?, ?> consumer;

    public ListenerContainerPartitionIdleEvent(Object source, Object container, long idleTime, String id, TopicPartition topicPartition, Consumer<?, ?> consumer, boolean paused) {
        super(source, container);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.topicPartition = topicPartition;
        this.consumer = consumer;
        this.paused = paused;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String toString() {
        return "ListenerContainerPartitionIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + String.valueOf(this.getSource()) + ", paused=" + this.paused + ", topicPartition=" + String.valueOf(this.topicPartition) + "]";
    }
}

