/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.Collection;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Suffixer {
    private final String suffix;

    public Suffixer(String suffix) {
        Assert.notNull((Object)suffix, (String)"Suffix cannot be null");
        this.suffix = suffix;
    }

    public @Nullable String maybeAddTo(@Nullable String source) {
        if (!StringUtils.hasText((String)this.suffix)) {
            return source;
        }
        return StringUtils.hasText((String)source) ? source.concat(this.suffix) : source;
    }

    public Collection<String> maybeAddTo(Collection<String> sources) {
        if (!StringUtils.hasText((String)this.suffix)) {
            return sources;
        }
        return sources.stream().map(source -> this.maybeAddTo((String)source)).collect(Collectors.toList());
    }
}

