/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.Assert;

public class FilteringBatchMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V, BatchMessageListener<K, V>>
implements BatchAcknowledgingConsumerAwareMessageListener<K, V> {
    private final boolean ackDiscarded;
    private final boolean consumerAware;

    public FilteringBatchMessageListenerAdapter(BatchMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        this(delegate, recordFilterStrategy, false);
    }

    public FilteringBatchMessageListenerAdapter(BatchMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy, boolean ackDiscarded) {
        super(delegate, recordFilterStrategy);
        this.ackDiscarded = ackDiscarded;
        this.consumerAware = this.delegateType.equals((Object)ListenerType.ACKNOWLEDGING_CONSUMER_AWARE) || this.delegateType.equals((Object)ListenerType.CONSUMER_AWARE);
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> records, @Nullable Acknowledgment acknowledgment, @Nullable Consumer<?, ?> consumer) {
        RecordFilterStrategy<K, V> recordFilterStrategy = this.getRecordFilterStrategy();
        List consumerRecords = recordFilterStrategy.filterBatch(records);
        Assert.state((consumerRecords != null ? 1 : 0) != 0, (String)"filter returned null from filterBatch");
        if (recordFilterStrategy.ignoreEmptyBatch() && consumerRecords.isEmpty() && acknowledgment != null) {
            acknowledgment.acknowledge();
        } else if (!consumerRecords.isEmpty() || this.consumerAware || !this.ackDiscarded && this.delegateType.equals((Object)ListenerType.ACKNOWLEDGING)) {
            this.invokeDelegate(consumerRecords, acknowledgment, consumer);
        } else if (this.ackDiscarded && acknowledgment != null) {
            acknowledgment.acknowledge();
        }
    }

    private void invokeDelegate(List<ConsumerRecord<K, V>> consumerRecords, @Nullable Acknowledgment acknowledgment, @Nullable Consumer<?, ?> consumer) {
        switch (this.delegateType) {
            case ACKNOWLEDGING_CONSUMER_AWARE: {
                ((BatchMessageListener)this.delegate).onMessage(consumerRecords, acknowledgment, consumer);
                break;
            }
            case ACKNOWLEDGING: {
                ((BatchMessageListener)this.delegate).onMessage(consumerRecords, acknowledgment);
                break;
            }
            case CONSUMER_AWARE: {
                ((BatchMessageListener)this.delegate).onMessage(consumerRecords, consumer);
                break;
            }
            case SIMPLE: {
                ((BatchMessageListener)this.delegate).onMessage(consumerRecords);
            }
        }
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> data) {
        this.onMessage(data, (Acknowledgment)null, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> data, @Nullable Acknowledgment acknowledgment) {
        this.onMessage(data, acknowledgment, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> data, @Nullable Consumer<?, ?> consumer) {
        this.onMessage(data, (Acknowledgment)null, consumer);
    }
}

