/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.OffsetAndMetadataProvider;
import org.springframework.kafka.support.LogIfLevelEnabled;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConsumerProperties {
    public static final long DEFAULT_POLL_TIMEOUT = 5000L;
    private static final int DEFAULT_COMMIT_RETRIES = 3;
    private final @Nullable String @Nullable [] topics;
    private final @Nullable Pattern topicPattern;
    private final @Nullable TopicPartitionOffset @Nullable [] topicPartitions;
    private long pollTimeout = 5000L;
    private @Nullable String groupId;
    private String clientId = "";
    private @Nullable ConsumerRebalanceListener consumerRebalanceListener;
    private @Nullable Duration syncCommitTimeout;
    private @Nullable OffsetCommitCallback commitCallback;
    private @Nullable OffsetAndMetadataProvider offsetAndMetadataProvider;
    private boolean syncCommits = true;
    private LogIfLevelEnabled.Level commitLogLevel = LogIfLevelEnabled.Level.DEBUG;
    private Properties kafkaConsumerProperties = new Properties();
    private @Nullable Duration authExceptionRetryInterval;
    private int commitRetries = 3;
    private boolean fixTxOffsets;
    private boolean checkDeserExWhenKeyNull;
    private boolean checkDeserExWhenValueNull;

    public ConsumerProperties(String ... topics) {
        Assert.notEmpty((Object[])topics, (String)"An array of topics must be provided");
        this.topics = (String[])topics.clone();
        this.topicPattern = null;
        this.topicPartitions = null;
    }

    public ConsumerProperties(@Nullable Pattern topicPattern) {
        this.topics = null;
        this.topicPattern = topicPattern;
        this.topicPartitions = null;
    }

    public ConsumerProperties(TopicPartitionOffset ... topicPartitions) {
        this.topics = null;
        this.topicPattern = null;
        Assert.notEmpty((Object[])topicPartitions, (String)"An array of topicPartitions must be provided");
        this.topicPartitions = Arrays.copyOf(topicPartitions, topicPartitions.length);
    }

    public @Nullable String @Nullable [] getTopics() {
        return this.topics != null ? Arrays.copyOf(this.topics, this.topics.length) : null;
    }

    public @Nullable Pattern getTopicPattern() {
        return this.topicPattern;
    }

    public @Nullable TopicPartitionOffset @Nullable [] getTopicPartitions() {
        return this.topicPartitions != null ? Arrays.copyOf(this.topicPartitions, this.topicPartitions.length) : null;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public @Nullable String getGroupId() {
        return this.groupId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setConsumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumerRebalanceListener = consumerRebalanceListener;
    }

    public @Nullable ConsumerRebalanceListener getConsumerRebalanceListener() {
        return this.consumerRebalanceListener;
    }

    public void setSyncCommitTimeout(@Nullable Duration syncCommitTimeout) {
        this.syncCommitTimeout = syncCommitTimeout;
    }

    public @Nullable Duration getSyncCommitTimeout() {
        return this.syncCommitTimeout;
    }

    public void setCommitCallback(OffsetCommitCallback commitCallback) {
        this.commitCallback = commitCallback;
    }

    public void setOffsetAndMetadataProvider(OffsetAndMetadataProvider offsetAndMetadataProvider) {
        this.offsetAndMetadataProvider = offsetAndMetadataProvider;
    }

    public @Nullable OffsetCommitCallback getCommitCallback() {
        return this.commitCallback;
    }

    public @Nullable OffsetAndMetadataProvider getOffsetAndMetadataProvider() {
        return this.offsetAndMetadataProvider;
    }

    public void setSyncCommits(boolean syncCommits) {
        this.syncCommits = syncCommits;
    }

    public boolean isSyncCommits() {
        return this.syncCommits;
    }

    public LogIfLevelEnabled.Level getCommitLogLevel() {
        return this.commitLogLevel;
    }

    public void setCommitLogLevel(LogIfLevelEnabled.Level commitLogLevel) {
        Assert.notNull((Object)((Object)commitLogLevel), (String)"'commitLogLevel' cannot be null");
        this.commitLogLevel = commitLogLevel;
    }

    public Properties getKafkaConsumerProperties() {
        return this.kafkaConsumerProperties;
    }

    public void setKafkaConsumerProperties(Properties kafkaConsumerProperties) {
        Assert.notNull((Object)kafkaConsumerProperties, (String)"'kafkaConsumerProperties' cannot be null");
        this.kafkaConsumerProperties = kafkaConsumerProperties;
    }

    public @Nullable Duration getAuthExceptionRetryInterval() {
        return this.authExceptionRetryInterval;
    }

    public void setAuthExceptionRetryInterval(Duration authExceptionRetryInterval) {
        this.authExceptionRetryInterval = authExceptionRetryInterval;
    }

    public int getCommitRetries() {
        return this.commitRetries;
    }

    public void setCommitRetries(int commitRetries) {
        this.commitRetries = commitRetries;
    }

    public boolean isFixTxOffsets() {
        return this.fixTxOffsets;
    }

    public void setFixTxOffsets(boolean fixTxOffsets) {
        this.fixTxOffsets = fixTxOffsets;
    }

    public boolean isCheckDeserExWhenKeyNull() {
        return this.checkDeserExWhenKeyNull;
    }

    public void setCheckDeserExWhenKeyNull(boolean checkDeserExWhenKeyNull) {
        this.checkDeserExWhenKeyNull = checkDeserExWhenKeyNull;
    }

    public boolean isCheckDeserExWhenValueNull() {
        return this.checkDeserExWhenValueNull;
    }

    public void setCheckDeserExWhenValueNull(boolean checkDeserExWhenValueNull) {
        this.checkDeserExWhenValueNull = checkDeserExWhenValueNull;
    }

    public String toString() {
        return "ConsumerProperties [" + this.renderProperties() + "]";
    }

    protected final String renderProperties() {
        StringBuilder sb = new StringBuilder();
        this.renderTopics(sb);
        sb.append("\n pollTimeout=").append(this.pollTimeout);
        if (this.groupId != null) {
            sb.append("\n groupId=").append(this.groupId);
        }
        if (StringUtils.hasText((String)this.clientId)) {
            sb.append("\n clientId=").append(this.clientId);
        }
        if (this.consumerRebalanceListener != null) {
            sb.append("\n consumerRebalanceListener=").append(this.consumerRebalanceListener);
        }
        if (this.commitCallback != null) {
            sb.append("\n commitCallback=").append(this.commitCallback);
        }
        if (this.offsetAndMetadataProvider != null) {
            sb.append("\n offsetAndMetadataProvider=").append(this.offsetAndMetadataProvider);
        }
        sb.append("\n syncCommits=").append(this.syncCommits);
        if (this.syncCommitTimeout != null) {
            sb.append("\n syncCommitTimeout=").append(this.syncCommitTimeout);
        }
        if (!this.kafkaConsumerProperties.isEmpty()) {
            sb.append("\n properties=").append(this.kafkaConsumerProperties);
        }
        sb.append("\n authExceptionRetryInterval=").append(this.authExceptionRetryInterval);
        sb.append("\n commitRetries=").append(this.commitRetries);
        sb.append("\n fixTxOffsets=").append(this.fixTxOffsets);
        return sb.toString();
    }

    private void renderTopics(StringBuilder sb) {
        if (this.topics != null) {
            sb.append("\n topics=").append(Arrays.toString(this.topics));
        }
        if (this.topicPattern != null) {
            sb.append("\n topicPattern=").append(this.topicPattern);
        }
        if (this.topicPartitions != null) {
            sb.append("\n topicPartitions=").append(Arrays.toString(this.topicPartitions));
        }
    }
}

