/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.util.StringUtils;

public class ListenerContainerFactoryResolver {
    private final BeanFactory beanFactory;
    private final List<FactoryResolver> mainEndpointResolvers;
    private final List<FactoryResolver> retryEndpointResolvers;
    private final Cache mainEndpointCache;
    private final Cache retryEndpointCache;

    public ListenerContainerFactoryResolver(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.mainEndpointCache = new Cache();
        this.retryEndpointCache = new Cache();
        FactoryResolver[] factoryResolverArray = new FactoryResolver[6];
        factoryResolverArray[0] = this.mainEndpointCache::fromCache;
        factoryResolverArray[1] = (fromKafkaListenerAnnotation, configuration) -> fromKafkaListenerAnnotation;
        factoryResolverArray[2] = (fromKLAnnotation, configuration) -> configuration.factoryFromRetryTopicConfiguration;
        factoryResolverArray[3] = (fromKLAnnotation, configuration) -> this.fromBeanName(configuration.listenerContainerFactoryName);
        factoryResolverArray[4] = (fromKLAnnotation, configuration) -> this.fromBeanName("internalRetryTopicListenerContainerFactory");
        factoryResolverArray[5] = (fromKLAnnotation, configuration) -> this.fromBeanName("defaultRetryTopicListenerContainerFactory");
        this.mainEndpointResolvers = Arrays.asList(factoryResolverArray);
        FactoryResolver[] factoryResolverArray2 = new FactoryResolver[6];
        factoryResolverArray2[0] = this.retryEndpointCache::fromCache;
        factoryResolverArray2[1] = (fromKLAnnotation, configuration) -> configuration.factoryFromRetryTopicConfiguration;
        factoryResolverArray2[2] = (fromKLAnnotation, configuration) -> this.fromBeanName(configuration.listenerContainerFactoryName);
        factoryResolverArray2[3] = (fromKLAnnotation, configuration) -> fromKLAnnotation;
        factoryResolverArray2[4] = (fromKLAnnotation, configuration) -> this.fromBeanName("internalRetryTopicListenerContainerFactory");
        factoryResolverArray2[5] = (fromKLAnnotation, configuration) -> this.fromBeanName("defaultRetryTopicListenerContainerFactory");
        this.retryEndpointResolvers = Arrays.asList(factoryResolverArray2);
    }

    ConcurrentKafkaListenerContainerFactory<?, ?> resolveFactoryForMainEndpoint(@Nullable KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotationInstance, String defaultContainerFactoryBeanName, Configuration config) {
        KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation = this.getFactoryFromKLA(factoryFromKafkaListenerAnnotationInstance, defaultContainerFactoryBeanName);
        ConcurrentKafkaListenerContainerFactory<?, ?> resolvedFactory = this.resolveFactory(this.mainEndpointResolvers, factoryFromKafkaListenerAnnotation, config);
        return this.mainEndpointCache.addIfAbsent(factoryFromKafkaListenerAnnotation, config, resolvedFactory);
    }

    ConcurrentKafkaListenerContainerFactory<?, ?> resolveFactoryForRetryEndpoint(@Nullable KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotationInstance, String defaultContainerFactoryBeanName, Configuration config) {
        KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation = this.getFactoryFromKLA(factoryFromKafkaListenerAnnotationInstance, defaultContainerFactoryBeanName);
        ConcurrentKafkaListenerContainerFactory<?, ?> resolvedFactory = this.resolveFactory(this.retryEndpointResolvers, factoryFromKafkaListenerAnnotation, config);
        return this.retryEndpointCache.addIfAbsent(factoryFromKafkaListenerAnnotation, config, resolvedFactory);
    }

    private @Nullable KafkaListenerContainerFactory<?> getFactoryFromKLA(@Nullable KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotationInstance, String defaultContainerFactoryBeanName) {
        KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation = factoryFromKafkaListenerAnnotationInstance;
        if (factoryFromKafkaListenerAnnotation == null) {
            factoryFromKafkaListenerAnnotation = this.fromBeanName(defaultContainerFactoryBeanName);
        }
        return factoryFromKafkaListenerAnnotation;
    }

    private ConcurrentKafkaListenerContainerFactory<?, ?> resolveFactory(List<FactoryResolver> factoryResolvers, @Nullable KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation, Configuration config) {
        ConcurrentKafkaListenerContainerFactory<?, ?> verifiedFactoryFromKafkaListenerAnnotation = this.verifyClass(factoryFromKafkaListenerAnnotation);
        return factoryResolvers.stream().map(resolver -> Optional.ofNullable(resolver.resolveFactory(verifiedFactoryFromKafkaListenerAnnotation, config))).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not resolve a viable ConcurrentKafkaListenerContainerFactory to configure the retry topic. Try creating a bean with name defaultRetryTopicListenerContainerFactory"));
    }

    private @Nullable ConcurrentKafkaListenerContainerFactory<?, ?> verifyClass(@Nullable KafkaListenerContainerFactory<?> fromKafkaListenerAnnotationFactory) {
        return fromKafkaListenerAnnotationFactory != null && ConcurrentKafkaListenerContainerFactory.class.isAssignableFrom(fromKafkaListenerAnnotationFactory.getClass()) ? (ConcurrentKafkaListenerContainerFactory)fromKafkaListenerAnnotationFactory : null;
    }

    private @Nullable ConcurrentKafkaListenerContainerFactory<?, ?> fromBeanName(String factoryBeanName) {
        try {
            return StringUtils.hasText((String)factoryBeanName) ? (ConcurrentKafkaListenerContainerFactory)this.beanFactory.getBean(factoryBeanName, ConcurrentKafkaListenerContainerFactory.class) : null;
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    static class Cache {
        private final Map<Key, ConcurrentKafkaListenerContainerFactory<?, ?>> cacheMap = new HashMap();

        Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConcurrentKafkaListenerContainerFactory<?, ?> addIfAbsent(KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation, Configuration config, ConcurrentKafkaListenerContainerFactory<?, ?> resolvedFactory) {
            Map<Key, ConcurrentKafkaListenerContainerFactory<?, ?>> map = this.cacheMap;
            synchronized (map) {
                Key key = this.cacheKey(factoryFromKafkaListenerAnnotation, config);
                this.cacheMap.putIfAbsent(key, resolvedFactory);
                return resolvedFactory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConcurrentKafkaListenerContainerFactory<?, ?> fromCache(KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation, Configuration config) {
            Map<Key, ConcurrentKafkaListenerContainerFactory<?, ?>> map = this.cacheMap;
            synchronized (map) {
                return this.cacheMap.get(this.cacheKey(factoryFromKafkaListenerAnnotation, config));
            }
        }

        private Key cacheKey(KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation, Configuration config) {
            return new Key(factoryFromKafkaListenerAnnotation, config);
        }

        static class Key {
            private final KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation;
            private final Configuration config;

            Key(KafkaListenerContainerFactory<?> factoryFromKafkaListenerAnnotation, Configuration config) {
                this.factoryFromKafkaListenerAnnotation = factoryFromKafkaListenerAnnotation;
                this.config = config;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Objects.equals(this.factoryFromKafkaListenerAnnotation, key.factoryFromKafkaListenerAnnotation) && Objects.equals(this.config, key.config);
            }

            public int hashCode() {
                return Objects.hash(this.factoryFromKafkaListenerAnnotation, this.config);
            }
        }
    }

    private static interface FactoryResolver {
        public ConcurrentKafkaListenerContainerFactory<?, ?> resolveFactory(ConcurrentKafkaListenerContainerFactory<?, ?> var1, Configuration var2);
    }

    static class Configuration {
        private final ConcurrentKafkaListenerContainerFactory<?, ?> factoryFromRetryTopicConfiguration;
        private final String listenerContainerFactoryName;

        Configuration(ConcurrentKafkaListenerContainerFactory<?, ?> factoryFromRetryTopicConfiguration, String listenerContainerFactoryName) {
            this.factoryFromRetryTopicConfiguration = factoryFromRetryTopicConfiguration;
            this.listenerContainerFactoryName = listenerContainerFactoryName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Configuration that = (Configuration)o;
            return Objects.equals(this.factoryFromRetryTopicConfiguration, that.factoryFromRetryTopicConfiguration) && Objects.equals(this.listenerContainerFactoryName, that.listenerContainerFactoryName);
        }

        public int hashCode() {
            return Objects.hash(this.factoryFromRetryTopicConfiguration, this.listenerContainerFactoryName);
        }
    }
}

