/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.DefaultKafkaHeaderMapper;
import org.springframework.kafka.support.JacksonPresent;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.KafkaMessageHeaders;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class BatchMessagingMessageConverter
implements BatchMessageConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RecordMessageConverter recordConverter;
    private boolean generateMessageId = false;
    private boolean generateTimestamp = false;
    private KafkaHeaderMapper headerMapper;

    public BatchMessagingMessageConverter() {
        this(null);
    }

    public BatchMessagingMessageConverter(RecordMessageConverter recordConverter) {
        this.recordConverter = recordConverter;
        if (JacksonPresent.isJackson2Present()) {
            this.headerMapper = new DefaultKafkaHeaderMapper();
        }
    }

    public void setGenerateMessageId(boolean generateMessageId) {
        this.generateMessageId = generateMessageId;
    }

    public void setGenerateTimestamp(boolean generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    public void setHeaderMapper(KafkaHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    @Override
    public Message<?> toMessage(List<ConsumerRecord<?, ?>> records, Acknowledgment acknowledgment, Type type) {
        KafkaMessageHeaders kafkaMessageHeaders = new KafkaMessageHeaders(this.generateMessageId, this.generateTimestamp);
        Map<String, Object> rawHeaders = kafkaMessageHeaders.getRawHeaders();
        ArrayList<Object> payloads = new ArrayList<Object>();
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        ArrayList<String> timestampTypes = new ArrayList<String>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        ArrayList<HashMap<String, Object>> convertedHeaders = new ArrayList<HashMap<String, Object>>();
        ArrayList<Headers> natives = new ArrayList<Headers>();
        rawHeaders.put("kafka_receivedMessageKey", keys);
        rawHeaders.put("kafka_receivedTopic", topics);
        rawHeaders.put("kafka_receivedPartitionId", partitions);
        rawHeaders.put("kafka_offset", offsets);
        rawHeaders.put("kafka_timestampType", timestampTypes);
        rawHeaders.put("kafka_receivedTimestamp", timestamps);
        if (this.headerMapper != null) {
            rawHeaders.put("kafka_batchConvertedHeaders", convertedHeaders);
        } else {
            rawHeaders.put("kafka_nativeHeaders", natives);
        }
        if (acknowledgment != null) {
            rawHeaders.put("kafka_acknowledgment", acknowledgment);
        }
        boolean logged = false;
        for (ConsumerRecord<?, ?> record : records) {
            payloads.add(this.recordConverter == null || !this.containerType(type) ? this.extractAndConvertValue(record, type) : this.convert(record, type));
            keys.add(record.key());
            topics.add(record.topic());
            partitions.add(record.partition());
            offsets.add(record.offset());
            timestampTypes.add(record.timestampType().name());
            timestamps.add(record.timestamp());
            if (this.headerMapper != null) {
                HashMap<String, Object> converted = new HashMap<String, Object>();
                this.headerMapper.toHeaders(record.headers(), converted);
                convertedHeaders.add(converted);
                continue;
            }
            if (this.logger.isDebugEnabled() && !logged) {
                this.logger.debug((Object)"No header mapper is available; Jackson is required for the default mapper; headers (if present) are not mapped but provided raw in kafka_nativeHeaders");
                logged = true;
            }
            natives.add(record.headers());
        }
        return MessageBuilder.createMessage(payloads, (MessageHeaders)kafkaMessageHeaders);
    }

    @Override
    public List<ProducerRecord<?, ?>> fromMessage(Message<?> message, String defaultTopic) {
        throw new UnsupportedOperationException();
    }

    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        return record.value() == null ? KafkaNull.INSTANCE : record.value();
    }

    protected Object convert(ConsumerRecord<?, ?> record, Type type) {
        return this.recordConverter.toMessage(record, null, ((ParameterizedType)type).getActualTypeArguments()[0]).getPayload();
    }

    private boolean containerType(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1;
    }
}

