/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.config;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class ContainerProperties {
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 10000;
    private final String[] topics;
    private final Pattern topicPattern;
    private final TopicPartitionInitialOffset[] topicPartitions;
    private AbstractMessageListenerContainer.AckMode ackMode = AbstractMessageListenerContainer.AckMode.BATCH;
    private int ackCount;
    private long ackTime;
    private Object messageListener;
    private volatile long pollTimeout = 1000L;
    private AsyncListenableTaskExecutor consumerTaskExecutor;
    private GenericErrorHandler<?> errorHandler;
    private long shutdownTimeout = 10000L;
    private ConsumerRebalanceListener consumerRebalanceListener;
    private OffsetCommitCallback commitCallback;
    private boolean syncCommits = true;
    private boolean ackOnError = true;
    private Long idleEventInterval;
    private String groupId;
    private PlatformTransactionManager transactionManager;
    private int monitorInterval = 30;
    private TaskScheduler scheduler;
    private float noPollThreshold;

    public ContainerProperties(String ... topics) {
        Assert.notEmpty((Object[])topics, (String)"An array of topicPartitions must be provided");
        this.topics = Arrays.asList(topics).toArray(new String[topics.length]);
        this.topicPattern = null;
        this.topicPartitions = null;
    }

    public ContainerProperties(Pattern topicPattern) {
        this.topics = null;
        this.topicPattern = topicPattern;
        this.topicPartitions = null;
    }

    public ContainerProperties(TopicPartitionInitialOffset ... topicPartitions) {
        this.topics = null;
        this.topicPattern = null;
        Assert.notEmpty((Object[])topicPartitions, (String)"An array of topicPartitions must be provided");
        this.topicPartitions = new LinkedHashSet<TopicPartitionInitialOffset>(Arrays.asList(topicPartitions)).toArray(new TopicPartitionInitialOffset[topicPartitions.length]);
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public void setAckMode(AbstractMessageListenerContainer.AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public void setAckCount(int count) {
        Assert.state((count > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
        this.ackCount = count;
    }

    public void setAckTime(long ackTime) {
        Assert.state((ackTime > 0L ? 1 : 0) != 0, (String)"'ackTime' must be > 0");
        this.ackTime = ackTime;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setConsumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
        this.consumerTaskExecutor = consumerTaskExecutor;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setConsumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumerRebalanceListener = consumerRebalanceListener;
    }

    public void setCommitCallback(OffsetCommitCallback commitCallback) {
        this.commitCallback = commitCallback;
    }

    public void setSyncCommits(boolean syncCommits) {
        this.syncCommits = syncCommits;
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setAckOnError(boolean ackOnError) {
        this.ackOnError = ackOnError;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    public TopicPartitionInitialOffset[] getTopicPartitions() {
        return this.topicPartitions;
    }

    public AbstractMessageListenerContainer.AckMode getAckMode() {
        return this.ackMode;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public AsyncListenableTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public GenericErrorHandler<?> getGenericErrorHandler() {
        return this.errorHandler;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public ConsumerRebalanceListener getConsumerRebalanceListener() {
        return this.consumerRebalanceListener;
    }

    public OffsetCommitCallback getCommitCallback() {
        return this.commitCallback;
    }

    public boolean isSyncCommits() {
        return this.syncCommits;
    }

    public Long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    public boolean isAckOnError() {
        return this.ackOnError && !AbstractMessageListenerContainer.AckMode.MANUAL_IMMEDIATE.equals((Object)this.ackMode) && !AbstractMessageListenerContainer.AckMode.MANUAL.equals((Object)this.ackMode);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public float getNoPollThreshold() {
        return this.noPollThreshold;
    }

    public void setNoPollThreshold(float noPollThreshold) {
        this.noPollThreshold = noPollThreshold;
    }
}

