/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.rule;

import java.util.Map;
import org.junit.rules.ExternalResource;
import org.springframework.kafka.test.EmbeddedKafkaBroker;

public class EmbeddedKafkaRule
extends ExternalResource {
    private final EmbeddedKafkaBroker embeddedKafka;

    public EmbeddedKafkaRule(int count) {
        this(count, false, new String[0]);
    }

    public EmbeddedKafkaRule(int count, boolean controlledShutdown, String ... topics) {
        this(count, controlledShutdown, 2, topics);
    }

    public EmbeddedKafkaRule(int count, boolean controlledShutdown, int partitions, String ... topics) {
        this.embeddedKafka = new EmbeddedKafkaBroker(count, controlledShutdown, partitions, topics);
    }

    public EmbeddedKafkaRule brokerProperties(Map<String, String> brokerProperties) {
        this.embeddedKafka.brokerProperties(brokerProperties);
        return this;
    }

    public EmbeddedKafkaRule brokerProperty(String property, Object value) {
        this.embeddedKafka.brokerProperty(property, value);
        return this;
    }

    public EmbeddedKafkaRule kafkaPorts(int ... kafkaPorts) {
        this.embeddedKafka.kafkaPorts(kafkaPorts);
        return this;
    }

    public EmbeddedKafkaRule zkPort(int port) {
        this.embeddedKafka.setZkPort(port);
        return this;
    }

    public EmbeddedKafkaBroker getEmbeddedKafka() {
        return this.embeddedKafka;
    }

    public void before() {
        this.embeddedKafka.afterPropertiesSet();
    }

    public void after() {
        this.embeddedKafka.destroy();
    }
}

