/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.integration.zip.transformer.ZipTransformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractZipTransformer
extends AbstractTransformer {
    private static final Log logger = LogFactory.getLog(ZipTransformer.class);
    protected volatile Charset charset = Charset.defaultCharset();
    protected volatile FileNameGenerator fileNameGenerator;
    protected ZipResultType zipResultType = ZipResultType.FILE;
    protected volatile File workDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + "ziptransformer");
    protected volatile boolean deleteFiles;

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setWorkDirectory(File workDirectory) {
        Assert.notNull((Object)workDirectory, (String)"workDirectory must not be null.");
        Assert.isTrue((!workDirectory.isFile() ? 1 : 0) != 0, (String)"The workDirectory specified must not point to a file");
        this.workDirectory = workDirectory;
    }

    public void setZipResultType(ZipResultType zipResultType) {
        Assert.notNull((Object)((Object)zipResultType), (String)"The zipResultType must not be empty.");
        this.zipResultType = zipResultType;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (!this.workDirectory.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Creating work directory '%s'.", this.workDirectory));
            }
            Assert.isTrue((boolean)this.workDirectory.mkdirs(), (String)("Can't create the 'workDirectory': " + this.workDirectory));
        }
        DefaultFileNameGenerator defaultFileNameGenerator = new DefaultFileNameGenerator();
        defaultFileNameGenerator.setBeanFactory(this.getBeanFactory());
        defaultFileNameGenerator.setConversionService(this.getConversionService());
        this.fileNameGenerator = defaultFileNameGenerator;
    }

    protected Object doTransform(Message<?> message) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        Object payload = message.getPayload();
        Assert.notNull((Object)payload, (String)"payload must not be null");
        return this.doZipTransform(message);
    }

    protected abstract Object doZipTransform(Message<?> var1) throws Exception;
}

