/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.outbound;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jxmpp.jid.impl.JidCreate;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareMessageHandler;
import org.springframework.integration.xmpp.support.DefaultXmppHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class ChatMessageSendingMessageHandler
extends AbstractXmppConnectionAwareMessageHandler {
    private static final Pattern XML_PATTERN = Pattern.compile("<(\\S[^>\\s]*)[^>]*>[^<]*</\\1>");
    private XmppHeaderMapper headerMapper = new DefaultXmppHeaderMapper();
    private ExtensionElementProvider<? extends ExtensionElement> extensionProvider;

    public ChatMessageSendingMessageHandler() {
    }

    public ChatMessageSendingMessageHandler(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setHeaderMapper(XmppHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExtensionProvider(ExtensionElementProvider<? extends ExtensionElement> extensionProvider) {
        this.extensionProvider = extensionProvider;
    }

    public String getComponentType() {
        return "xmpp:outbound-channel-adapter";
    }

    protected void handleMessageInternal(org.springframework.messaging.Message<?> message) {
        Assert.isTrue((boolean)this.isInitialized(), () -> this.getComponentName() + "#" + this.getComponentType() + " must be initialized");
        try {
            XMPPConnection xmppConnection;
            Message xmppMessage;
            Object payload = message.getPayload();
            if (payload instanceof Message) {
                xmppMessage = (Message)payload;
            } else {
                String to = (String)message.getHeaders().get((Object)"xmpp_to", String.class);
                Assert.state((boolean)StringUtils.hasText((String)to), () -> "The 'xmpp_to' header must not be null");
                xmppMessage = this.buildXmppMessage(payload, to);
            }
            if (this.headerMapper != null) {
                this.headerMapper.fromHeadersToRequest(message.getHeaders(), xmppMessage);
            }
            if (!(xmppConnection = this.getXmppConnection()).isConnected() && xmppConnection instanceof AbstractXMPPConnection) {
                ((AbstractXMPPConnection)xmppConnection).connect();
            }
            xmppConnection.sendStanza((Stanza)xmppMessage);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessageHandlingException(message, "Thread interrupted in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to handle message in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
    }

    private Message buildXmppMessage(Object payload, String to) throws Exception {
        Message xmppMessage = new Message(JidCreate.from((String)to));
        if (payload instanceof ExtensionElement) {
            xmppMessage.addExtension((ExtensionElement)payload);
        } else if (payload instanceof String) {
            if (this.extensionProvider != null) {
                String data = (String)payload;
                if (!XML_PATTERN.matcher(data.trim()).matches()) {
                    data = "<root>" + data + "</root>";
                }
                XmlPullParser xmlPullParser = PacketParserUtils.newXmppParser((Reader)new StringReader(data));
                xmlPullParser.next();
                ExtensionElement extension = (ExtensionElement)this.extensionProvider.parse(xmlPullParser);
                xmppMessage.addExtension(extension);
            } else {
                xmppMessage.setBody((String)payload);
            }
        } else {
            throw new IllegalStateException("Only payloads of type java.lang.String, org.jivesoftware.smack.packet.Message or org.jivesoftware.smack.packet.ExtensionElement are supported. Received [" + payload.getClass().getName() + "]. Consider adding a Transformer prior to this adapter.");
        }
        return xmppMessage;
    }
}

