/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.router;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class XPathRouter
extends AbstractMappingMessageRouter {
    private final NodeMapper<Object> nodeMapper = new TextContentNodeMapper();
    private final XPathExpression xPathExpression;
    private XmlPayloadConverter converter = new DefaultXmlPayloadConverter();
    private boolean evaluateAsString = false;

    public XPathRouter(String expression, Map<String, String> namespaces) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
    }

    public XPathRouter(String expression, String prefix, String namespace) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(prefix, namespace);
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
    }

    public XPathRouter(String expression) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.xPathExpression = XPathExpressionFactory.createXPathExpression((String)expression);
    }

    public XPathRouter(XPathExpression expression) {
        Assert.notNull((Object)expression, (String)"expression must not be null");
        this.xPathExpression = expression;
    }

    public void setEvaluateAsString(boolean evaluateAsString) {
        this.evaluateAsString = evaluateAsString;
    }

    public void setConverter(XmlPayloadConverter converter) {
        Assert.notNull((Object)converter, (String)"converter must not be null");
        this.converter = converter;
    }

    public String getComponentType() {
        return "xml:xpath-router";
    }

    protected List<Object> getChannelKeys(Message<?> message) {
        Node node = this.converter.convertToNode(message.getPayload());
        if (this.evaluateAsString) {
            return Collections.singletonList(Objects.requireNonNull(this.xPathExpression.evaluateAsString(node)));
        }
        return this.xPathExpression.evaluate(node, this.nodeMapper);
    }

    private static class TextContentNodeMapper
    implements NodeMapper<Object> {
        TextContentNodeMapper() {
        }

        public @Nullable Object mapNode(Node node, int nodeNum) throws DOMException {
            return node.getTextContent();
        }
    }
}

